/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import jp.fourthline.mmlTools.ComposeRank;
import jp.fourthline.mmlTools.MMLCutter;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.core.MMLTools;
import jp.fourthline.mmlTools.core.MelodyParser;

public class DrumTools
extends MMLTools {
    private boolean makiOption = false;

    public DrumTools(String string) {
        super(string);
    }

    public double getOverSec() throws MMLException {
        return this.getMabinogiTime() - this.getPlayTime();
    }

    public void setMakiOption(boolean bl) {
        this.makiOption = bl;
    }

    private void cutMMLDrum(ComposeRank composeRank) {
        MMLCutter mMLCutter = new MMLCutter(this.mml_melody);
        this.mml_melody = mMLCutter.cut(composeRank.getMelody(), this.makiOption);
        this.mml_chord1 = mMLCutter.cut(composeRank.getChord1(), this.makiOption);
        this.mml_chord2 = mMLCutter.cut(composeRank.getChord2() + 1000, false);
    }

    private void drumChord2InsertPlaylength(boolean bl) throws MMLException {
        double d = this.getPlayTime();
        double d2 = this.chord2Parser.getPlayLengthByTempoList();
        double d3 = d - d2;
        double d4 = d3 * 96.0 / (double)MMLTicks.getTick("1.");
        d4 *= 0.5333333333333333;
        StringBuffer stringBuffer = new StringBuffer(this.mml_chord2);
        if (this.chord2Parser.getTempo() != 32) {
            stringBuffer.append("t32");
        }
        if (!this.chord2Parser.getMmlL().equals("1.")) {
            stringBuffer.append("l1.");
        }
        int n = 1;
        while ((double)n < d4) {
            stringBuffer.append('r');
            ++n;
        }
        if (!bl) {
            stringBuffer.append(this.tailLength(d4));
        } else {
            stringBuffer.append('r');
        }
        System.out.println("beats: " + d4);
        this.mml_chord2 = stringBuffer.toString();
        this.chord2Parser = new MelodyParser(this.mml_chord2, "4", this.chord1Parser.getTempo());
    }

    private String tailLength(double d) {
        String[] stringArray = new String[]{"1", "2", "4", "8", "12", "16", "32"};
        double d2 = d - Math.floor(d);
        Object object = "";
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                double d3 = (double)MMLTicks.getTick(stringArray[i]) / 51.2 / 11.25;
                if (!(d3 < d2)) continue;
                d2 -= d3;
                object = (String)object + "r" + stringArray[i];
            }
        }
        catch (MMLException mMLException) {
            return "<Internal_ERROR>";
        }
        return object;
    }

    public String makeForMabiMML(ComposeRank composeRank) throws MMLException {
        return this.makeForMabiMML(composeRank, true);
    }

    public String makeForMabiMML(ComposeRank composeRank, boolean bl) throws MMLException {
        this.cutMMLDrum(composeRank);
        this.parseMMLforMabinogi();
        this.parsePlayMode(true);
        if (this.mml_chord1 != "") {
            this.clearTimeCalc();
            this.drumChord2InsertPlaylength(bl);
        }
        return this.getMML();
    }

    int convDrumVol(int n) {
        int[] nArray = new int[]{0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 10, 11};
        if (n < 0 || n >= nArray.length) {
            return 0;
        }
        return nArray[n];
    }

    public String disDrumVolume() throws MMLException {
        String string;
        MMLTokenizer mMLTokenizer = new MMLTokenizer(this.mml_melody);
        StringBuffer stringBuffer = new StringBuffer(this.mml_melody.length());
        while (mMLTokenizer.hasNext()) {
            string = mMLTokenizer.next();
            if (string.startsWith("v") || string.startsWith("V")) {
                String string2 = string.substring(1);
                int n = Integer.parseInt(string2);
                n = this.convDrumVol(n);
                stringBuffer.append(string.charAt(0));
                stringBuffer.append(n);
                continue;
            }
            stringBuffer.append(string);
        }
        this.mml_melody = string = stringBuffer.toString();
        return string;
    }
}

