/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLTickTable;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public class MMLConverter {
    private final MMLTickTable.Switch useTable;
    private boolean allTempoPart = false;
    private boolean allowNOpt = false;

    public MMLConverter(MMLTickTable.Switch switch_) {
        this.useTable = switch_;
    }

    public void setOption(boolean bl, boolean bl2) {
        this.allTempoPart = bl;
        this.allowNOpt = bl2;
    }

    public String convertMML(List<MMLEventList> list) throws MMLExceptionList {
        MMLTickTable.getInstance().tableInvSwitch(this.useTable);
        String string = null;
        try {
            string = this.getGenericMMLStrings(list);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            MMLTickTable.getInstance().tableInvSwitch(null);
        }
        return string;
    }

    private String optimize(String string) {
        MMLStringOptimizer mMLStringOptimizer = new MMLStringOptimizer(string).setDisableNopt(!this.allowNOpt);
        String string2 = mMLStringOptimizer.optimizeGen2();
        return string2;
    }

    private boolean verify(MMLEventList mMLEventList, String string) {
        String string2;
        MMLEventList mMLEventList2 = new MMLEventList(string, null, 0);
        String string3 = mMLEventList2.getMMLNoteEventList().stream().filter(mMLNoteEvent -> mMLNoteEvent.getVelocity() > 0).toList().toString();
        boolean bl = string3.equals(string2 = mMLEventList.getMMLNoteEventList().stream().filter(mMLNoteEvent -> mMLNoteEvent.getVelocity() > 0).toList().toString());
        if (!bl) {
            System.out.println(string);
            System.out.println(string2);
            System.out.println(string3);
        }
        return bl;
    }

    private String getGenericMMLStrings(List<MMLEventList> list) throws MMLExceptionList {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>();
        LinkedList linkedList = new LinkedList();
        try {
            for (int i = 0; i < list.size(); ++i) {
                MMLEventList mMLEventList = list.get(i);
                LinkedList<MMLTempoEvent> linkedList2 = this.allTempoPart || i == 0 ? new LinkedList<MMLTempoEvent>(mMLEventList.getGlobalTempoList()) : linkedList;
                String string = MMLBuilder.create(mMLEventList, 0, 4).toMMLStringMusicQ(linkedList2, null);
                if (!this.verify(mMLEventList, string = this.optimize(string))) {
                    return null;
                }
                if (string.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
        }
        catch (MMLExceptionList mMLExceptionList) {
            arrayList.addAll(mMLExceptionList.getErr());
        }
        if (!arrayList.isEmpty()) {
            throw new MMLExceptionList(arrayList);
        }
        stringBuilder.insert(0, "MML@");
        stringBuilder.append(";");
        return stringBuilder.toString();
    }
}

