/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.fourthline.mmlTools.core.IllegalTickOffsetException;
import jp.fourthline.mmlTools.core.MMLException;

public abstract class MMLEvent
implements Serializable {
    private static final long serialVersionUID = -6142467143073639266L;
    public static final int MAX_TICK = 3840000;
    private int tickOffset;

    protected MMLEvent(int n) {
        if (n <= -3840000 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public void setTickOffset(int n) {
        if (n < 0 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    public abstract String toString();

    public abstract String toMMLString() throws MMLException;

    public static void insertTick(List<? extends MMLEvent> list, int n, int n2) {
        for (MMLEvent mMLEvent : list) {
            int n3 = mMLEvent.getTickOffset();
            if (n3 < n) continue;
            mMLEvent.setTickOffset(n3 + n2);
        }
    }

    public static void removeTick(List<? extends MMLEvent> list, int n, int n2) {
        ArrayList<MMLEvent> arrayList = new ArrayList<MMLEvent>();
        for (MMLEvent mMLEvent : list) {
            int n3 = mMLEvent.getTickOffset();
            if (n3 < n) continue;
            if (n3 < n + n2) {
                arrayList.add(mMLEvent);
                continue;
            }
            mMLEvent.setTickOffset(n3 - n2);
        }
        for (MMLEvent mMLEvent : arrayList) {
            list.remove(mMLEvent);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MMLEvent)) {
            return false;
        }
        MMLEvent mMLEvent = (MMLEvent)object;
        return this.tickOffset == mMLEvent.tickOffset;
    }
}

