/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.parser.MMLEventParser;

public final class MMLEventList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1430758411579285535L;
    private List<MMLNoteEvent> noteList = new ArrayList<MMLNoteEvent>();
    private List<MMLTempoEvent> tempoList;

    public MMLEventList(String string) {
        this(string, null);
    }

    public MMLEventList(String string, List<MMLTempoEvent> list) {
        this.tempoList = list != null ? list : new ArrayList<MMLTempoEvent>();
        this.parseMML(string, 0);
    }

    public MMLEventList(String string, List<MMLTempoEvent> list, int n) {
        this.tempoList = list != null ? list : new ArrayList<MMLTempoEvent>();
        this.parseMML(string, n);
    }

    private void parseMML(String string, int n) {
        MMLEventParser mMLEventParser = new MMLEventParser(string, n);
        while (mMLEventParser.hasNext()) {
            MMLEvent mMLEvent = mMLEventParser.next();
            if (mMLEvent instanceof MMLTempoEvent) {
                MMLTempoEvent mMLTempoEvent = (MMLTempoEvent)mMLEvent;
                mMLTempoEvent.appendToListElement(this.tempoList);
                continue;
            }
            if (!(mMLEvent instanceof MMLNoteEvent)) continue;
            MMLNoteEvent mMLNoteEvent = (MMLNoteEvent)mMLEvent;
            this.noteList.add(mMLNoteEvent);
        }
    }

    public void setGlobalTempoList(List<MMLTempoEvent> list) {
        this.tempoList = list;
    }

    public List<MMLTempoEvent> getGlobalTempoList() {
        return this.tempoList;
    }

    public long getTickLength() {
        if (this.noteList.size() > 0) {
            int n = this.noteList.size() - 1;
            MMLNoteEvent mMLNoteEvent = this.noteList.get(n);
            return mMLNoteEvent.getEndTick();
        }
        return 0L;
    }

    public boolean isEmpty() {
        return this.noteList.isEmpty();
    }

    public List<MMLNoteEvent> getMMLNoteEventList() {
        return this.noteList;
    }

    public MMLNoteEvent searchOnTickOffset(long l) {
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            if ((long)mMLNoteEvent.getTickOffset() > l) break;
            if (l >= (long)mMLNoteEvent.getEndTick()) continue;
            return mMLNoteEvent;
        }
        return null;
    }

    public MMLNoteEvent searchOnTickOffsetNextNote(long l) {
        int n = this.noteList.size();
        for (int i = 0; i < n - 1; ++i) {
            MMLNoteEvent mMLNoteEvent = this.noteList.get(i);
            if ((long)mMLNoteEvent.getTickOffset() > l || l >= (long)mMLNoteEvent.getEndTick()) continue;
            return this.noteList.get(i + 1);
        }
        return null;
    }

    public MMLNoteEvent searchPrevNoteOnTickOffset(long l) {
        MMLNoteEvent mMLNoteEvent = null;
        for (MMLNoteEvent mMLNoteEvent2 : this.noteList) {
            if ((long)mMLNoteEvent2.getTickOffset() >= l) break;
            mMLNoteEvent = mMLNoteEvent2;
        }
        return mMLNoteEvent;
    }

    public int[] indexOfMMLString(long l) {
        int n = 0;
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            int[] nArray = mMLNoteEvent.getIndexOfMMLString();
            if ((long)mMLNoteEvent.getTickOffset() <= l) {
                if (l < (long)mMLNoteEvent.getEndTick()) {
                    return nArray;
                }
            } else {
                return new int[]{n, nArray[0]};
            }
            n = nArray[1];
        }
        return new int[]{n, n};
    }

    public void addMMLNoteEvent(MMLNoteEvent mMLNoteEvent) {
        int n;
        MMLNoteEvent mMLNoteEvent2;
        int n2;
        if (mMLNoteEvent.getNote() < -1 || mMLNoteEvent.getTick() <= 0 || mMLNoteEvent.getEndTick() <= 0) {
            return;
        }
        int n3 = mMLNoteEvent.getTickOffset();
        if (n3 < 0) {
            mMLNoteEvent.setTick(mMLNoteEvent.getTick() + n3);
            mMLNoteEvent.setTickOffset(0);
        }
        for (n2 = 0; n2 < this.noteList.size(); ++n2) {
            mMLNoteEvent2 = this.noteList.get(n2);
            n = mMLNoteEvent2.getEndTick() - mMLNoteEvent.getTickOffset();
            if (mMLNoteEvent.getTickOffset() < mMLNoteEvent2.getTickOffset()) break;
            if (n < 0) continue;
            int n4 = mMLNoteEvent2.getTick() - n;
            if (n4 == 0) {
                this.noteList.remove(n2);
                break;
            }
            mMLNoteEvent2.setTick(n4);
            break;
        }
        int n5 = ++n2;
        ++n2;
        this.noteList.add(n5, mMLNoteEvent);
        while (n2 < this.noteList.size()) {
            mMLNoteEvent2 = this.noteList.get(n2);
            n = mMLNoteEvent.getEndTick() - mMLNoteEvent2.getTickOffset();
            if (n <= 0) break;
            this.noteList.remove(n2);
        }
    }

    public boolean isOverlapNote(MMLNoteEvent mMLNoteEvent) {
        MMLNoteEvent mMLNoteEvent2;
        int n;
        int n2 = this.noteList.size();
        for (n = 0; n < n2; ++n) {
            mMLNoteEvent2 = this.noteList.get(n);
            if (mMLNoteEvent.getTickOffset() >= mMLNoteEvent2.getEndTick()) continue;
            if (mMLNoteEvent.getTickOffset() < mMLNoteEvent2.getTickOffset()) break;
            return true;
        }
        while (n < n2) {
            mMLNoteEvent2 = this.noteList.get(n);
            if (mMLNoteEvent.getEndTick() <= mMLNoteEvent2.getEndTick()) {
                if (mMLNoteEvent.getEndTick() - 1 < mMLNoteEvent2.getTickOffset()) break;
                return true;
            }
            ++n;
        }
        return false;
    }

    public void deleteMMLEvent(MMLEvent mMLEvent) {
        this.noteList.remove(mMLEvent);
    }

    public void setVelocityCommand(MMLNoteEvent mMLNoteEvent, int n) {
        this.setUnsetVelocityCommand(mMLNoteEvent, n, true);
    }

    public void unsetVelocityCommand(MMLNoteEvent mMLNoteEvent) {
        this.setUnsetVelocityCommand(mMLNoteEvent, 0, false);
    }

    private void setUnsetVelocityCommand(MMLNoteEvent mMLNoteEvent, int n, boolean bl) {
        int n2 = mMLNoteEvent.getVelocity();
        int n3 = 8;
        for (MMLNoteEvent mMLNoteEvent2 : this.noteList) {
            if (mMLNoteEvent2.getTickOffset() >= mMLNoteEvent.getTickOffset()) {
                if (n2 != mMLNoteEvent2.getVelocity()) break;
                mMLNoteEvent2.setVelocity(bl ? n : n3);
                continue;
            }
            n3 = mMLNoteEvent2.getVelocity();
        }
    }

    public String toString() {
        return this.tempoList.toString() + this.noteList.toString();
    }

    public MMLEventList clone() {
        try {
            MMLEventList mMLEventList = (MMLEventList)super.clone();
            mMLEventList.noteList = new ArrayList<MMLNoteEvent>();
            for (MMLNoteEvent mMLEvent : this.noteList) {
                mMLEventList.noteList.add(mMLEvent.clone());
            }
            mMLEventList.tempoList = new ArrayList<MMLTempoEvent>();
            for (MMLTempoEvent mMLTempoEvent : this.tempoList) {
                mMLEventList.tempoList.add(mMLTempoEvent.clone());
            }
            return mMLEventList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException.getMessage());
        }
    }

    public int getAlignmentStartTick(MMLEventList mMLEventList, int n) {
        MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n);
        if (mMLNoteEvent == null || mMLNoteEvent.getTickOffset() == n) {
            return n;
        }
        return mMLEventList.getAlignmentStartTick(this, mMLNoteEvent.getTickOffset());
    }

    public int getAlignmentEndTick(MMLEventList mMLEventList, int n) {
        MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n - 1);
        if (mMLNoteEvent == null || mMLNoteEvent.getEndTick() == n) {
            return n;
        }
        return mMLEventList.getAlignmentEndTick(this, mMLNoteEvent.getEndTick());
    }

    public void swap(MMLEventList mMLEventList, int n, int n2) {
        ArrayList<MMLNoteEvent> arrayList = new ArrayList<MMLNoteEvent>();
        ArrayList<MMLNoteEvent> arrayList2 = new ArrayList<MMLNoteEvent>();
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            if (mMLNoteEvent.getTickOffset() < n || mMLNoteEvent.getEndTick() > n2) continue;
            arrayList.add(mMLNoteEvent);
        }
        for (MMLNoteEvent mMLNoteEvent : arrayList) {
            this.noteList.remove(mMLNoteEvent);
        }
        for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
            if (mMLNoteEvent.getTickOffset() < n || mMLNoteEvent.getEndTick() > n2) continue;
            arrayList2.add(mMLNoteEvent);
        }
        for (MMLNoteEvent mMLNoteEvent : arrayList2) {
            mMLEventList.getMMLNoteEventList().remove(mMLNoteEvent);
            this.addMMLNoteEvent(mMLNoteEvent);
        }
        for (MMLNoteEvent mMLNoteEvent : arrayList) {
            mMLEventList.addMMLNoteEvent(mMLNoteEvent);
        }
    }

    public void move(MMLEventList mMLEventList, int n, int n2) {
        ArrayList<MMLNoteEvent> arrayList = new ArrayList<MMLNoteEvent>();
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            if (mMLNoteEvent.getTickOffset() < n || mMLNoteEvent.getEndTick() > n2) continue;
            arrayList.add(mMLNoteEvent);
        }
        for (MMLNoteEvent mMLNoteEvent : arrayList) {
            this.deleteMMLEvent(mMLNoteEvent);
            mMLEventList.addMMLNoteEvent(mMLNoteEvent);
        }
    }

    public void copy(MMLEventList mMLEventList, int n, int n2) {
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            if (mMLNoteEvent.getTickOffset() < n || mMLNoteEvent.getEndTick() > n2) continue;
            mMLEventList.addMMLNoteEvent(mMLNoteEvent.clone());
        }
    }

    public void deleteMinRest() {
        int n = MMLTicks.minimumTick();
        int n2 = this.noteList.size();
        for (int i = 1; i < n2; ++i) {
            MMLNoteEvent mMLNoteEvent = this.noteList.get(i - 1);
            MMLNoteEvent mMLNoteEvent2 = this.noteList.get(i);
            int n3 = mMLNoteEvent2.getTickOffset() - mMLNoteEvent.getEndTick();
            if (n3 <= 0 || n3 >= n) continue;
            int n4 = mMLNoteEvent.getTick() - n + n3;
            if (n4 >= n) {
                mMLNoteEvent.setTick(n4);
                continue;
            }
            mMLNoteEvent.setTick(mMLNoteEvent.getTick() + n3);
        }
    }

    public void transpose(int n) {
        for (MMLNoteEvent mMLNoteEvent : this.noteList) {
            mMLNoteEvent.setNote(mMLNoteEvent.getNote() + n);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MMLEventList)) {
            return false;
        }
        MMLEventList mMLEventList = (MMLEventList)object;
        return Arrays.equals(this.noteList.toArray(), mMLEventList.noteList.toArray()) && Arrays.equals(this.tempoList.toArray(), mMLEventList.tempoList.toArray());
    }

    public MMLNoteEvent getLastNote() {
        int n = this.noteList.size() - 1;
        if (n >= 0) {
            return this.noteList.get(n);
        }
        return null;
    }

    public String getInternalMMLString() throws MMLExceptionList {
        return MMLBuilder.create(this).toMMLString(false, false);
    }

    public static int maxEndTick(List<MMLEventList> list) {
        int n = 0;
        for (MMLEventList mMLEventList : list) {
            MMLNoteEvent mMLNoteEvent = mMLEventList.getLastNote();
            if (mMLNoteEvent == null || n >= mMLNoteEvent.getEndTick()) continue;
            n = mMLNoteEvent.getEndTick();
        }
        return n;
    }
}

