/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.fourthline.mabiicco.Utils;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.optimizer.CacheMap;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.MMLParseException;
import jp.fourthline.mmlTools.parser.SectionContents;
import jp.fourthline.mmlTools.parser.TextParser;

public final class MMLScoreSerializer
extends AbstractMMLParser {
    private static final String SCORE_SECTION = "[mml-score]";
    private static final String MARKER_SECTION = "[marker]";
    private static final String TIME_SIGNATURE_SECTION = "[time-signature]";
    private static final String SCORE_VERSION = "version=1";
    private static final String TITLE = "title=";
    private static final String AUTHOR = "author=";
    private static final String TIME = "time=";
    private static final String TEMPO = "tempo=";
    private static final String MML_TRACK = "mml-track=";
    private static final String TRACK_NAME = "name=";
    private static final String PROGRAM = "program=";
    private static final String SONG_PROGRAM = "songProgram=";
    private static final String PANPOT = "panpot=";
    private static final String VOLUME = "volume=";
    private static final String VOLUME_COMPAT = "volumn=";
    private static final String VISIBLE = "visible=";
    private static final String START_OFFSET = "startOffset=";
    private static final String START_DELTA = "startDelta=";
    private static final String START_SONG_DELTA = "startSongDelta=";
    private static final String DELAY = "attackDelayCorrect=";
    private static final String SONG_DELAY = "attackSongDelayCorrect=";
    private static final String DISABLE_NOPT = "disableNopt=";
    private static final String IMPORTED_DATA = "IDATA=";
    private static final String TEMPO_ONLY_MELODY = "tempoOnlyMelody";
    private final MMLScore score;
    private MMLTrack lastTrack = null;
    private final TextParser parser;
    private final ParseCache cache = new ParseCache();
    private static final String IMPORTED_DATA_MAGIC = "L#Vs";
    private static Map<String, List<MMLEventList>> importedDataCache = Collections.synchronizedMap(new CacheMap(8));

    public MMLScoreSerializer(MMLScore mMLScore) {
        this.score = mMLScore;
        this.parser = new TextParser().pattern(START_OFFSET, string -> {
            this.cache.startOffset = Integer.parseInt(string);
        }).pattern(START_DELTA, string -> {
            this.cache.startDelta = Integer.parseInt(string);
        }).pattern(START_SONG_DELTA, string -> {
            this.cache.startSongDelta = Integer.parseInt(string);
        }).pattern(MML_TRACK, string -> {
            this.lastTrack = new MMLTrack(this.cache.startOffset, this.cache.startDelta, this.cache.startSongDelta).setMML((String)string);
            mMLScore.addTrack(this.lastTrack);
            this.cache.clear();
        }).pattern(TRACK_NAME, string -> this.getLastTrack().setTrackName((String)string)).pattern(PROGRAM, string -> this.getLastTrack().setProgram(Integer.parseInt(string))).pattern(SONG_PROGRAM, string -> this.getLastTrack().setSongProgram(Integer.parseInt(string))).pattern(PANPOT, string -> this.getLastTrack().setPanpot(Integer.parseInt(string))).pattern(VOLUME, string -> this.getLastTrack().setVolume(Integer.parseInt(string))).pattern(VOLUME_COMPAT, string -> this.getLastTrack().setVolume(Integer.parseInt(string))).pattern(VISIBLE, string -> this.getLastTrack().setVisible(Boolean.parseBoolean(string))).pattern(DELAY, string -> this.getLastTrack().setAttackDelayCorrect(Integer.parseInt(string))).pattern(SONG_DELAY, string -> this.getLastTrack().setAttackSongDelayCorrect(Integer.parseInt(string))).pattern(DISABLE_NOPT, string -> this.getLastTrack().setDisableNopt(Boolean.parseBoolean(string))).pattern(TITLE, string -> mMLScore.setTitle((String)string)).pattern(AUTHOR, string -> mMLScore.setAuthor((String)string)).pattern(TIME, string -> mMLScore.setBaseTime((String)string)).pattern(TEMPO, string -> this.putTempoObj((String)string)).pattern(IMPORTED_DATA, string -> this.getLastTrack().setImportedData((String)string)).pattern(TEMPO_ONLY_MELODY, string -> this.getLastTrack().setOptTempoOnlyMelody(true));
    }

    @Override
    public MMLScore parse(InputStream inputStream) throws MMLParseException {
        this.score.getTempoEventList().clear();
        this.score.getTrackList().clear();
        this.score.getMarkerList().clear();
        this.score.getTimeSignatureList().clear();
        List<SectionContents> list = SectionContents.makeSectionContentsByInputStream(inputStream, "UTF-8");
        if (list.isEmpty()) {
            throw new MMLParseException("empty");
        }
        for (SectionContents sectionContents : list) {
            if (sectionContents.getName().equals(SCORE_SECTION)) {
                this.parseMMLScore(sectionContents.getContents());
                continue;
            }
            if (sectionContents.getName().equals(MARKER_SECTION)) {
                this.parseMarker(sectionContents.getContents());
                continue;
            }
            if (!sectionContents.getName().equals(TIME_SIGNATURE_SECTION)) continue;
            this.parseTimeSignature(sectionContents.getContents());
        }
        return this.score;
    }

    private void putTempoObj(String string) {
        if (string.length() > 0) {
            String[] stringArray = string.split(",");
            this.score.getTempoEventList().clear();
            for (String string2 : stringArray) {
                MMLTempoEvent mMLTempoEvent = MMLTempoEvent.fromString(string2);
                if (mMLTempoEvent == null) continue;
                mMLTempoEvent.appendToListElement(this.score.getTempoEventList());
            }
        }
    }

    private String fixMMLspace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("MML@", n)) >= 0) {
            int n3 = string.indexOf(59, n2);
            stringBuilder.append(string, n, n2);
            stringBuilder.append(string.substring(n2, n3 + 1).replaceAll("[ \t\f\r\n]", ""));
            n = n3 + 1;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private MMLTrack getLastTrack() {
        if (this.lastTrack != null) {
            return this.lastTrack;
        }
        throw new IllegalStateException();
    }

    private void parseMMLScore(String string) {
        this.parser.parse(this.fixMMLspace(string));
    }

    private void parseMarker(String string) {
        this.score.getMarkerList().clear();
        for (String string2 : string.split("\n")) {
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.score.getMarkerList().add(new Marker(string4, Integer.parseInt(string3)));
        }
    }

    private void parseTimeSignature(String string) {
        this.score.getTimeSignatureList().clear();
        for (String string2 : string.split("\n")) {
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String[] stringArray = string2.substring(n + 1).split("/");
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            try {
                this.score.addTimeSignature(new TimeSignature(this.score, Integer.parseInt(string3), n2, n3));
            }
            catch (NumberFormatException | MMLException exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getTempoObj() {
        List<MMLTempoEvent> list = this.score.getTempoEventList();
        if (list.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MMLTempoEvent mMLTempoEvent : list) {
            stringBuilder.append(',');
            stringBuilder.append(mMLTempoEvent.toString());
        }
        return stringBuilder.substring(1);
    }

    private int getStartOffsetAll() {
        List<MMLTrack> list = this.score.getTrackList();
        if (list.size() > 0) {
            return list.get(0).getCommonStartOffset();
        }
        return 0;
    }

    private void writeMMLEventList(PrintStream printStream, String string, List<? extends MMLEvent> list) {
        if (!list.isEmpty()) {
            printStream.println(string);
            for (MMLEvent mMLEvent : list) {
                printStream.println(mMLEvent.toString());
            }
        }
    }

    public static String toStringImportedData(List<MMLEventList> list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBytes(IMPORTED_DATA_MAGIC);
            dataOutputStream.writeByte(list.size());
            for (MMLEventList object2 : list) {
                List<MMLNoteEvent> list2 = object2.getMMLNoteEventList();
                dataOutputStream.writeInt(list2.size());
                for (MMLNoteEvent mMLNoteEvent : list2) {
                    dataOutputStream.writeShort(mMLNoteEvent.getNote());
                    dataOutputStream.writeInt(mMLNoteEvent.getTickOffset());
                    dataOutputStream.writeInt(mMLNoteEvent.getTick());
                    dataOutputStream.writeShort(mMLNoteEvent.getVelocity());
                }
            }
            int n = 0;
            for (byte by : byteArrayOutputStream.toByteArray()) {
                n += by;
            }
            dataOutputStream.writeByte(n);
            String string = Utils.compress(byteArrayOutputStream.toByteArray());
            if (!importedDataCache.containsKey(string)) {
                importedDataCache.put(string, list);
            }
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static List<MMLEventList> parseImportedData(String string) {
        if (string == null) {
            return null;
        }
        if (importedDataCache.containsKey(string)) {
            return importedDataCache.get(string);
        }
        byte[] byArray = Utils.decompress(string);
        if (byArray == null) {
            importedDataCache.put(string, null);
            return null;
        }
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            if (!new String(dataInputStream.readNBytes(IMPORTED_DATA_MAGIC.length())).equals(IMPORTED_DATA_MAGIC)) {
                System.err.println("imported data: invalid magic");
                importedDataCache.put(string, null);
                return null;
            }
            int n3 = dataInputStream.readByte();
            ArrayList<MMLEventList> arrayList = new ArrayList<MMLEventList>();
            for (n2 = 0; n2 < n3; ++n2) {
                MMLEventList mMLEventList = new MMLEventList("");
                int n4 = dataInputStream.readInt();
                for (int i = 0; i < n4; ++i) {
                    short s = dataInputStream.readShort();
                    int n5 = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    short s2 = dataInputStream.readShort();
                    MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(s, n6, n5, s2);
                    mMLEventList.addMMLNoteEvent(mMLNoteEvent);
                }
                arrayList.add(mMLEventList);
            }
            n2 = 0;
            for (n = 0; n < byArray.length - 1; ++n) {
                n2 += byArray[n];
            }
            n = dataInputStream.readByte();
            if ((n2 &= 0xFF) != (n &= 0xFF)) {
                System.err.println("imported data: sum error");
                importedDataCache.put(string, null);
                return null;
            }
            importedDataCache.put(string, arrayList);
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            importedDataCache.put(string, null);
            return null;
        }
    }

    public void writeToOutputStream(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream, false, StandardCharsets.UTF_8);
        printStream.println(SCORE_SECTION);
        printStream.println(SCORE_VERSION);
        printStream.println(TITLE + this.score.getTitle());
        printStream.println(AUTHOR + this.score.getAuthor());
        printStream.println(TIME + this.score.getBaseTime());
        printStream.println(TEMPO + this.getTempoObj());
        if (this.getStartOffsetAll() > 0) {
            printStream.println(START_OFFSET + this.getStartOffsetAll());
        }
        for (MMLTrack mMLTrack : this.score.getTrackList()) {
            if (mMLTrack.getStartDelta() != 0) {
                printStream.println(START_DELTA + mMLTrack.getStartDelta());
            }
            if (mMLTrack.getStartSongDelta() != 0) {
                printStream.println(START_SONG_DELTA + mMLTrack.getStartSongDelta());
            }
            printStream.println(MML_TRACK + mMLTrack.getOriginalMML());
            String string = mMLTrack.getImportedData();
            if (string != null) {
                printStream.println(IMPORTED_DATA + string);
            }
            printStream.println(TRACK_NAME + mMLTrack.getTrackName());
            printStream.println(PROGRAM + mMLTrack.getProgram());
            printStream.println(SONG_PROGRAM + mMLTrack.getSongProgram());
            printStream.println(PANPOT + mMLTrack.getPanpot());
            if (mMLTrack.getVolume() != 100) {
                printStream.println(VOLUME + mMLTrack.getVolume());
            }
            printStream.println(VISIBLE + mMLTrack.isVisible());
            if (mMLTrack.getAttackDelayCorrect() != 0) {
                printStream.println(DELAY + mMLTrack.getAttackDelayCorrect());
            }
            if (mMLTrack.getAttackSongDelayCorrect() != 0) {
                printStream.println(SONG_DELAY + mMLTrack.getAttackSongDelayCorrect());
            }
            if (mMLTrack.getDisableNopt()) {
                printStream.println(DISABLE_NOPT + mMLTrack.getDisableNopt());
            }
            if (!mMLTrack.getOptTempoMelodyOnly()) continue;
            printStream.println(TEMPO_ONLY_MELODY);
        }
        this.writeMMLEventList(printStream, MARKER_SECTION, this.score.getMarkerList());
        this.writeMMLEventList(printStream, TIME_SIGNATURE_SECTION, this.score.getTimeSignatureList());
        printStream.close();
    }

    private static final class ParseCache {
        private int startOffset = 0;
        private int startDelta = 0;
        private int startSongDelta = 0;

        private ParseCache() {
        }

        private void clear() {
            this.startDelta = 0;
            this.startSongDelta = 0;
        }
    }
}

