/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.IllegalTickOffsetException;

public final class MMLTempoConverter {
    private final List<MMLTempoEvent> oldTempoList;
    private final List<MMLTempoEvent> newTempoList;
    private double convertD = 0.0;
    private int convertDCount = 0;

    MMLTempoConverter(List<MMLTempoEvent> list, List<MMLTempoEvent> list2) {
        this.oldTempoList = list;
        this.newTempoList = new ArrayList<MMLTempoEvent>();
        list2.forEach(mMLTempoEvent -> this.newTempoList.add(new MMLTempoEvent(mMLTempoEvent.getTempo(), this.convertEvent(mMLTempoEvent.getTickOffset(), false))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int convertEvent(int n, boolean bl) {
        double d = MMLTempoConverter.getTickOffsetOnTime(this.newTempoList, MMLTempoConverter.getTimeOnTickOffset(this.oldTempoList, n));
        long l = Math.round(d);
        if (Math.abs(l) > 3840000L) {
            throw new IllegalTickOffsetException((int)l);
        }
        int n2 = (int)l;
        if (bl) {
            MMLTempoConverter mMLTempoConverter = this;
            synchronized (mMLTempoConverter) {
                this.convertD += Math.abs(d - (double)n2);
                ++this.convertDCount;
            }
        }
        return n2;
    }

    public static MMLTempoConverter convert(MMLScore mMLScore, List<MMLTempoEvent> list) {
        List<MMLTempoEvent> list2 = mMLScore.getTempoEventList();
        MMLTempoConverter mMLTempoConverter = new MMLTempoConverter(list2, list);
        mMLScore.getTrackList().parallelStream().forEach(mMLTrack -> {
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    int n = mMLTempoConverter.convertEvent(mMLNoteEvent.getEndTick(), true);
                    int n2 = mMLTempoConverter.convertEvent(mMLNoteEvent.getTickOffset(), true);
                    mMLNoteEvent.setTickOffset(n2);
                    mMLNoteEvent.setTick(n - n2);
                }
            }
        });
        mMLScore.getMarkerList().forEach(marker -> marker.setTickOffset(mMLTempoConverter.convertEvent(marker.getTickOffset(), true)));
        list2.clear();
        list2.addAll(mMLTempoConverter.newTempoList);
        return mMLTempoConverter;
    }

    public String getConversionDiff() {
        return String.format("%.3f/%d", this.convertD, this.convertDCount);
    }

    public static double getTimeOnTickOffset(List<MMLTempoEvent> list, int n) {
        MMLTempoEvent mMLTempoEvent;
        int n2;
        double d = 0.0;
        int n3 = 120;
        int n4 = 0;
        Iterator<MMLTempoEvent> iterator = list.iterator();
        while (iterator.hasNext() && n >= (n2 = (mMLTempoEvent = iterator.next()).getTickOffset())) {
            int n5 = mMLTempoEvent.getTempo();
            if (n3 != n5) {
                d += (double)(n2 - n4) * 60000.0 / (double)n3;
                n4 = n2;
            }
            n3 = n5;
        }
        return (d += (double)(n - n4) * 60000.0 / (double)n3) / 96.0;
    }

    public static double getTickOffsetOnTime(List<MMLTempoEvent> list, double d) {
        MMLTempoEvent mMLTempoEvent;
        double d2;
        int n = 120;
        double d3 = 0.0;
        double d4 = 0.0;
        Iterator<MMLTempoEvent> iterator = list.iterator();
        while (iterator.hasNext() && !(d <= (d2 = MMLTempoConverter.getTimeOnTickOffset(list, (mMLTempoEvent = iterator.next()).getTickOffset())))) {
            d3 = d2;
            n = mMLTempoEvent.getTempo();
            d4 = mMLTempoEvent.getTickOffset();
        }
        return d4 += (d - d3) * 96.0 * (double)n / 60.0 / 1000.0;
    }
}

