/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import jp.fourthline.mmlTools.MMLEvent;

public final class MMLTempoEvent
extends MMLEvent
implements Cloneable {
    private static final long serialVersionUID = 8014294359518840951L;
    private int tempo;
    private final boolean isFirst;
    public static final int META = 81;
    public static final int INITIAL_TEMPO = 120;

    public MMLTempoEvent(int n, int n2) throws IllegalArgumentException {
        this(n, n2, false);
    }

    public MMLTempoEvent(int n, int n2, boolean bl) throws IllegalArgumentException {
        super(n2);
        if (n <= 0 || n > 1000) {
            throw new IllegalArgumentException("tempo " + n);
        }
        this.tempo = n;
        this.isFirst = bl;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int n) {
        this.tempo = n;
    }

    public byte[] getMetaData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(60000000 / this.tempo);
        byte[] byArray = byteBuffer.array();
        return Arrays.copyOfRange(byArray, 1, byArray.length);
    }

    @Override
    public String toString() {
        return this.getTickOffset() + "T" + this.tempo;
    }

    public static MMLTempoEvent fromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("T");
        if (stringArray.length != 2) {
            return null;
        }
        return new MMLTempoEvent(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[0]));
    }

    @Override
    public String toMMLString() {
        return "t" + this.tempo;
    }

    public void appendToListElement(List<MMLTempoEvent> list) {
        int n;
        int n2 = this.getTickOffset();
        for (n = 0; n < list.size(); ++n) {
            MMLTempoEvent mMLTempoEvent = list.get(n);
            if (mMLTempoEvent.getTickOffset() == n2) {
                list.remove(n);
                break;
            }
            if (mMLTempoEvent.getTickOffset() > n2) break;
        }
        if (n == 0 || list.get(n - 1).getTempo() != this.tempo || !this.isFirst) {
            list.add(n, this);
        }
    }

    public static List<MMLTempoEvent> mergeTempoList(List<MMLTempoEvent> list, List<MMLTempoEvent> list2) {
        if (list != list2) {
            for (MMLTempoEvent mMLTempoEvent : list) {
                mMLTempoEvent.appendToListElement(list2);
            }
        }
        return list2;
    }

    public static int searchOnTick(List<MMLTempoEvent> list, long l) {
        int n = 120;
        for (MMLTempoEvent mMLTempoEvent : list) {
            if (l < (long)mMLTempoEvent.getTickOffset()) break;
            n = mMLTempoEvent.getTempo();
        }
        return n;
    }

    public static boolean searchEqualsTick(List<MMLTempoEvent> list, long l) {
        for (MMLTempoEvent mMLTempoEvent : list) {
            if ((long)mMLTempoEvent.getTickOffset() == l) {
                return true;
            }
            if ((long)mMLTempoEvent.getTickOffset() <= l) continue;
            break;
        }
        return false;
    }

    public static MMLTempoEvent getMaxTempoEvent(List<MMLTempoEvent> list) {
        MMLTempoEvent mMLTempoEvent = new MMLTempoEvent(120, 0);
        for (MMLTempoEvent mMLTempoEvent2 : list) {
            int n = mMLTempoEvent2.getTempo();
            if (mMLTempoEvent.getTempo() >= n) continue;
            mMLTempoEvent.setTempo(n);
        }
        return mMLTempoEvent;
    }

    public MMLTempoEvent clone() {
        try {
            return (MMLTempoEvent)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MMLTempoEvent)) {
            return false;
        }
        MMLTempoEvent mMLTempoEvent = (MMLTempoEvent)object;
        return this.tempo == mMLTempoEvent.tempo && super.equals(mMLTempoEvent);
    }
}

