/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public final class TimeSignature
extends MMLEvent {
    private static final long serialVersionUID = 8326662121191415432L;
    public static final String[] TIME_COUNT_LIST;
    public static final String[] TIME_BASE_LIST;
    private int numTime;
    private int baseTick;
    private int measureOffset;

    public TimeSignature(MMLScore mMLScore, int n, int n2, int n3) throws MMLException {
        super(n);
        this.numTime = n2;
        this.baseTick = MMLTicks.getTick(Integer.toString(n3));
        this.measureOffset = TimeSignature.tickToMeasure(mMLScore, n);
    }

    public TimeSignature(MMLScore mMLScore, int n, String string, String string2) throws MMLException {
        this(mMLScore, n, Integer.parseInt(string), Integer.parseInt(string2));
    }

    @Override
    public void setTickOffset(int n) {
    }

    private void setViewTickOffset(int n) {
        super.setTickOffset(n);
    }

    static void recalcTimeSignatureList(MMLScore mMLScore) {
        List<TimeSignature> list = mMLScore.getTimeSignatureList();
        list.sort(Comparator.comparingInt(timeSignature -> timeSignature.getMeasureOffset()));
        for (TimeSignature timeSignature2 : list) {
            int n = TimeSignature.measureToCalcTick(mMLScore, timeSignature2.getMeasureOffset());
            timeSignature2.setViewTickOffset(n);
        }
    }

    public static int tickToMeasure(MMLScore mMLScore, int n) {
        TimeSignature timeSignature;
        Iterator<TimeSignature> iterator = mMLScore.getTimeSignatureList().iterator();
        int n2 = mMLScore.getTimeCountOnly();
        int n3 = mMLScore.getBeatTick();
        int n4 = 0;
        TimeSignature timeSignature2 = timeSignature = iterator.hasNext() ? iterator.next() : null;
        while (n3 <= n) {
            int n5;
            if (timeSignature != null && n4 >= timeSignature.getMeasureOffset()) {
                n2 = timeSignature.getNumTime();
                n3 = timeSignature.getBaseTick();
                TimeSignature timeSignature3 = timeSignature = iterator.hasNext() ? iterator.next() : null;
            }
            if ((n5 = n2 * n3) <= n) {
                ++n4;
                n -= n5;
                continue;
            }
            n -= n3;
        }
        return n4;
    }

    public static int measureToTick(MMLScore mMLScore, int n) {
        List<TimeSignature> list = mMLScore.getTimeSignatureList();
        int n2 = mMLScore.getTimeCountOnly();
        int n3 = mMLScore.getBeatTick();
        int n4 = 0;
        int n5 = 0;
        for (TimeSignature timeSignature : list) {
            if (timeSignature.getMeasureOffset() > n) break;
            n5 = timeSignature.getTickOffset();
            n4 = timeSignature.getMeasureOffset();
            n3 = timeSignature.getBaseTick();
            n2 = timeSignature.getNumTime();
        }
        return n5 + (n - n4) * (n2 * n3);
    }

    static int measureToCalcTick(MMLScore mMLScore, int n) {
        TimeSignature timeSignature;
        Iterator<TimeSignature> iterator = mMLScore.getTimeSignatureList().iterator();
        int n2 = mMLScore.getTimeCountOnly() * mMLScore.getBeatTick();
        int n3 = 0;
        int n4 = 0;
        TimeSignature timeSignature2 = timeSignature = iterator.hasNext() ? iterator.next() : null;
        while (n3 < n) {
            if (timeSignature != null && n3 >= timeSignature.getMeasureOffset()) {
                n2 = timeSignature.getNumTime() * timeSignature.getBaseTick();
                timeSignature = iterator.hasNext() ? iterator.next() : null;
            }
            ++n3;
            n4 += n2;
        }
        return n4;
    }

    public static void addMeasure(MMLScore mMLScore, int n) {
        List<TimeSignature> list = mMLScore.getTimeSignatureList();
        for (int i = 0; i < list.size(); ++i) {
            TimeSignature timeSignature = list.get(i);
            if (timeSignature.getMeasureOffset() <= n) continue;
            ++timeSignature.measureOffset;
        }
        TimeSignature.recalcTimeSignatureList(mMLScore);
    }

    public static void removeMeasure(MMLScore mMLScore, int n) {
        List<TimeSignature> list = mMLScore.getTimeSignatureList();
        for (int i = 0; i < list.size(); ++i) {
            TimeSignature timeSignature = list.get(i);
            if (timeSignature.getMeasureOffset() <= n) continue;
            --timeSignature.measureOffset;
            if (i <= 0 || list.get(i - 1).getMeasureOffset() != timeSignature.measureOffset) continue;
            list.remove(--i);
        }
        TimeSignature.recalcTimeSignatureList(mMLScore);
    }

    public int getNumTime() {
        return this.numTime;
    }

    public int getBaseTick() {
        return this.baseTick;
    }

    public int getMeasureOffset() {
        return this.measureOffset;
    }

    @Override
    public String toString() {
        try {
            String string = new MMLTicks("", this.baseTick).toMMLText();
            return String.format("%d=%d/%s", this.getTickOffset(), this.numTime, string);
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
            return "";
        }
    }

    @Override
    public String toMMLString() {
        try {
            String string = new MMLTicks("", this.baseTick).toMMLText();
            return String.format("%d/%s", this.numTime, string);
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
            return "";
        }
    }

    static {
        TIME_BASE_LIST = new String[]{"1", "2", "4", "8", "16", "32", "64"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= 32; ++i) {
            arrayList.add(Integer.toString(i));
        }
        arrayList.add(Integer.toString(64));
        TIME_COUNT_LIST = (String[])arrayList.toArray(String[]::new);
    }
}

