/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public class MMLRestTicks
extends MMLTicks {
    private static final String REST = "r";
    private static final String ALT = "c";
    private static final double DIV = 4.294967295E9;
    private final MMLNoteEvent prevNoteEvent;
    private boolean replaced = false;
    private boolean lastReplaced = false;

    public MMLRestTicks(int n) {
        this(n, null);
    }

    public MMLRestTicks(int n, MMLNoteEvent mMLNoteEvent) {
        super(REST, n, false);
        this.prevNoteEvent = mMLNoteEvent;
    }

    int calcDivTick(int n) {
        return (int)Math.ceil(4.294967295E9 * (double)n / 6.0E7);
    }

    private void vZero(StringBuilder stringBuilder) {
        int n = stringBuilder.lastIndexOf(REST);
        stringBuilder.replace(n, n + 1, ALT);
        if (this.prevNoteEvent != null && this.prevNoteEvent.getVelocity() > 0) {
            stringBuilder.insert(n, "v0");
            this.prevNoteEvent.setVelocity(0);
        }
    }

    public MMLNoteEvent getPrevNoteEvent() {
        return this.prevNoteEvent;
    }

    public String toMMLTextWithMotionFix(int n) throws MMLException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = this.calcDivTick(n);
        int n5 = MMLRestTicks.getTick("1.");
        int n6 = MMLRestTicks.getTick("1");
        for (n2 = this.tick; n2 > n6 * 2; n2 -= n5) {
            stringBuilder.append(this.mmlNotePart("1."));
            if ((n3 += n5) < n4) continue;
            n3 = n5;
            this.vZero(stringBuilder);
            this.replaced = true;
        }
        String string = this.makeMMLText(stringBuilder, n2);
        if ((n3 += n2) >= n4) {
            stringBuilder = new StringBuilder(string);
            this.vZero(stringBuilder);
            string = stringBuilder.toString();
            this.lastReplaced = true;
            this.replaced = true;
        }
        return string;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public boolean isLastReplaced() {
        return this.lastReplaced;
    }
}

