/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import jp.fourthline.mabiicco.Utils;
import jp.fourthline.mmlTools.core.Combination;
import jp.fourthline.mmlTools.core.NanoTime;

public final class MMLTickTable {
    private static final int COMBN = 3;
    public static final int TPQN = 96;
    private final Map<String, Integer> tickTable = MMLTickTable.generateTickTable(96, true);
    private final IntMap<MMLPattern> tickInvTable;
    private IntMap<MMLPattern> tickInvTableForMb;
    private static MMLTickTable obj = null;
    private Switch tableInvSwitch = null;

    public void tableInvSwitch(Switch switch_) {
        this.tableInvSwitch = switch_;
    }

    public static synchronized MMLTickTable getInstance() {
        if (obj == null) {
            InputStream inputStream = null;
            String string = System.getProperty("mabiicco.ticktable");
            if (string != null) {
                inputStream = MMLTickTable.class.getResourceAsStream(string);
            }
            obj = new MMLTickTable(inputStream);
        }
        return obj;
    }

    MMLTickTable(InputStream inputStream) {
        this.tickInvTable = inputStream == null ? this.generateInvTable() : this.readFromCompressedInputStreamInvTable(inputStream);
        this.tickInvTableForMb = this.generateInvTable(new String[]{"1", "1.", "2", "2.", "4", "4.", "8", "8.", "16", "16.", "32", "32.", "64", "64.", "6", "12", "24", "48"});
    }

    IntMap<MMLPattern> getInvTable() {
        if (this.tableInvSwitch != null) {
            switch (this.tableInvSwitch) {
                case FULL: {
                    return this.tickInvTable;
                }
                case MB: {
                    return this.tickInvTableForMb;
                }
            }
        }
        return this.tickInvTable;
    }

    public Map<String, Integer> getTable() {
        return this.tickTable;
    }

    private static void add(Map<String, Integer> map, int n, int n2, boolean bl) {
        int n3 = n * 4 / n2;
        if (bl) {
            n3 += n3 / 2;
        }
        String string = n2 + (bl ? "." : "");
        map.put(string, n3);
    }

    private static void add2(Map<String, Integer> map, int n, int n2, boolean bl) {
        double d = (double)n * 4.0 / (double)n2;
        if (bl) {
            d += d / 2.0;
        }
        String string = n2 + (bl ? "." : "");
        map.put(string, (int)d);
    }

    private static Map<String, Integer> generateTickTable(int n, boolean bl) {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (int i = 1; i <= 64; ++i) {
            if (bl) {
                MMLTickTable.add(linkedHashMap, n, i, true);
                MMLTickTable.add(linkedHashMap, n, i, false);
                continue;
            }
            MMLTickTable.add2(linkedHashMap, n, i, true);
            MMLTickTable.add2(linkedHashMap, n, i, false);
        }
        return linkedHashMap;
    }

    private IntMap<MMLPattern> generateInvTable() {
        String[] stringArray = this.tickTable.keySet().toArray(new String[0]);
        return this.generateInvTable(stringArray);
    }

    private IntMap<MMLPattern> generateInvTable(String[] stringArray) {
        return MMLTickTable.generateInvTable(stringArray, this.tickTable, n -> n);
    }

    private static IntMap<MMLPattern> generateInvTable(String[] stringArray, Map<String, Integer> map, IntFunction<Integer> intFunction) {
        NanoTime nanoTime = NanoTime.start();
        HashMap<Integer, MMLPattern> hashMap = new HashMap<Integer, MMLPattern>(1024);
        int n = map.get("1") * 2 - 1;
        for (int i = 1; i <= 3; ++i) {
            List<List<String>> list = new Combination<String>(stringArray, i).getArray();
            for (List<String> list2 : list) {
                int n2;
                int n3 = list2.stream().mapToInt(map::get).sum();
                if (n3 > n || (n2 = intFunction.apply(n3).intValue()) <= 0) continue;
                MMLPattern mMLPattern = (MMLPattern)hashMap.get(n2);
                if (mMLPattern == null) {
                    hashMap.put(n2, new MMLPattern(list2));
                    continue;
                }
                mMLPattern.put(list2);
            }
        }
        System.out.println("MMLTickTable " + nanoTime.ms() + "ms");
        return new IntMap<MMLPattern>(hashMap);
    }

    void writeToOutputStreamInvTable(OutputStream outputStream) {
        this.writeToOutputStreamInvTable(outputStream, false);
    }

    void writeToOutputStreamInvTable(OutputStream outputStream, boolean bl) {
        PrintStream printStream = new PrintStream(outputStream, false, StandardCharsets.UTF_8);
        IntMap<MMLPattern> intMap = this.getInvTable();
        printStream.println("# Generated Text --- ");
        printStream.println("# registered key: " + intMap.validCount());
        int n = intMap.max();
        for (int i = 1; i <= n; ++i) {
            if (intMap.containsKey(i)) {
                printStream.print(i + "=");
                intMap.get((int)i).primary.forEach(string -> printStream.print("[" + string + "]"));
                if (bl) {
                    intMap.get((int)i).alt.forEach(list -> {
                        printStream.print('\t');
                        list.forEach(string -> printStream.print("[" + string + "]"));
                    });
                }
                printStream.println();
                continue;
            }
            printStream.println("# " + i + "=<< not supported >>");
        }
    }

    private IntMap<MMLPattern> readFromCompressedInputStreamInvTable(InputStream inputStream) {
        try {
            byte[] byArray = inputStream.readAllBytes();
            byte[] byArray2 = Utils.decompress(new String(byArray, StandardCharsets.UTF_8));
            if (byArray2 != null) {
                return this.readFromInputStreamInvTable(new ByteArrayInputStream(byArray2));
            }
            return this.readFromInputStreamInvTable(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private IntMap<MMLPattern> readFromInputStreamInvTable(InputStream inputStream) {
        NanoTime nanoTime = NanoTime.start();
        HashMap hashMap = new HashMap(1024);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        bufferedReader.lines().forEach(string -> {
            if (!string.startsWith("#")) {
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String[] stringArray = string.substring(n + 1).split("\t");
                MMLPattern mMLPattern = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (string3.length() > 0) {
                        int n2 = string3.indexOf(93);
                        String string4 = string3.substring(1, n2);
                        arrayList.add(string4);
                        string3 = string3.substring(n2 + 1);
                    }
                    if (i == 0) {
                        mMLPattern = new MMLPattern(arrayList);
                        hashMap.put(Integer.parseInt(string2), mMLPattern);
                        continue;
                    }
                    mMLPattern.alt.add(arrayList);
                }
            }
        });
        IntMap<MMLPattern> intMap = new IntMap<MMLPattern>(hashMap);
        System.out.println("read tickTable: " + nanoTime.ms() + "ms");
        return intMap;
    }

    private void printTickList() {
        this.writeToOutputStreamInvTable(System.out, true);
    }

    public boolean verify() {
        if (this.tickInvTable == null) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeToOutputStreamInvTable(byteArrayOutputStream, true);
        String string = byteArrayOutputStream.toString();
        string = string.replaceAll("\r\n", "\n");
        int n = string.hashCode();
        return 1130216622 == n;
    }

    public static void main(String[] stringArray) {
        MMLTickTable mMLTickTable = new MMLTickTable(null);
        if (stringArray.length == 0) {
            mMLTickTable.printTickList();
            mMLTickTable.verify();
        } else {
            try (FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);){
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                mMLTickTable.writeToOutputStreamInvTable(byteArrayOutputStream, true);
                String string = Utils.compress(byteArrayOutputStream.toByteArray());
                fileOutputStream.write(string.getBytes());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static enum Switch {
        FULL,
        MB;

    }

    public static final class IntMap<T> {
        private final T[] array;

        public IntMap(Map<Integer, T> map) {
            ArrayList<T> arrayList = new ArrayList<T>();
            int n = (Integer)map.keySet().stream().max(Integer::compare).get();
            for (int i = 0; i <= n; ++i) {
                arrayList.add(map.get(i));
            }
            this.array = arrayList.toArray();
        }

        public int max() {
            return this.array.length;
        }

        public int validCount() {
            int n = 0;
            for (T t : this.array) {
                if (t == null) continue;
                ++n;
            }
            return n;
        }

        public boolean containsKey(int n) {
            return n >= 0 && n < this.array.length ? this.array[n] != null : false;
        }

        public T get(int n) {
            return n >= 0 && n < this.array.length ? (T)this.array[n] : null;
        }
    }

    static class MMLPattern {
        List<String> primary = null;
        List<List<String>> alt = new ArrayList<List<String>>();

        private MMLPattern(List<String> list) {
            this.primary = list;
        }

        private int patternLength(List<String> list) {
            int n = 0;
            List<String> list2 = Arrays.asList("1", "2", "4", "8", "16");
            for (String string2 : list) {
                if (list2.stream().anyMatch(string2::equals)) {
                    n += string2.length();
                    continue;
                }
                if (list2.stream().map(string -> string + ".").anyMatch(string2::equals)) {
                    n += string2.length() * 2;
                    continue;
                }
                n += string2.length() * 3;
            }
            return n + list.size() * 10;
        }

        private void put(List<String> list) {
            if (this.patternLength(list) <= this.patternLength(this.primary)) {
                if (list.size() == 2) {
                    this.alt.add(this.primary);
                }
                this.primary = list;
            } else if (list.size() == 2) {
                this.alt.add(list);
            }
        }
    }
}

