/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public enum TuningBase {
    L64("64"),
    L32("32"),
    L16("16"),
    L48("48"),
    L24("24"),
    L12("12");

    private final String base;
    private int tick;

    private TuningBase(String string2) {
        this.base = string2;
        try {
            this.tick = MMLTicks.getTick(string2);
        }
        catch (MMLException mMLException) {
            this.tick = 0;
        }
    }

    public String getBase() {
        return this.base;
    }

    public int getTick() {
        return this.tick;
    }

    public static TuningBase getInstance(int n) {
        for (TuningBase tuningBase : TuningBase.values()) {
            if (tuningBase.tick != n) continue;
            return tuningBase;
        }
        return null;
    }
}

