/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public final class BpCmOptimizer
implements MMLStringOptimizer.Optimizer {
    private final StringBuilder builder = new StringBuilder();
    private final StringBuilder optBuilder = new StringBuilder();
    private BpCmState state = BpCmState.NONE;

    @Override
    public void nextToken(String string) {
        BpCmState bpCmState = this.state;
        this.state = this.state.nextStatus(string);
        if (MMLStringOptimizer.getDebug()) {
            System.out.println(bpCmState + " - > " + this.state + ": " + string);
        }
        if (this.state == BpCmState.NONE) {
            this.builder.append((CharSequence)this.optBuilder);
            this.optBuilder.setLength(0);
            this.builder.append(string);
        } else {
            this.optBuilder.append(string);
            if (this.state == BpCmState.B3 || this.state == BpCmState.C3) {
                this.builder.append(this.state.optimize(this.optBuilder));
                this.optBuilder.setLength(0);
                this.state = this.state.nextStatus(string);
            }
        }
    }

    @Override
    public String getMinString() {
        this.builder.append((CharSequence)this.optBuilder);
        this.optBuilder.setLength(0);
        return this.builder.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum BpCmState {
        NONE{

            @Override
            public BpCmState nextStatus(String string) {
                if (string.equals("<")) {
                    return B1;
                }
                if (string.equals(">")) {
                    return C1;
                }
                return NONE;
            }
        }
        ,
        B1{

            @Override
            public BpCmState nextStatus(String string) {
                if (BpCmState.isNoteWithoutR(string)) {
                    if (MMLTokenizer.noteNames(string)[0].equalsIgnoreCase("b")) {
                        return B2;
                    }
                    return NONE;
                }
                if (string.equals(">")) {
                    return C1;
                }
                return B1;
            }
        }
        ,
        B2{

            @Override
            public BpCmState nextStatus(String string) {
                if (BpCmState.isNoteWithoutR(string)) {
                    return NONE;
                }
                if (string.equals(">")) {
                    return B3;
                }
                return B2;
            }
        }
        ,
        B3{

            @Override
            public String optimize(StringBuilder stringBuilder) {
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("<"));
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(">"));
                return stringBuilder.toString().replace("b", "c-").replace("B", "C-");
            }
        }
        ,
        C1{

            @Override
            public BpCmState nextStatus(String string) {
                if (BpCmState.isNoteWithoutR(string)) {
                    if (MMLTokenizer.noteNames(string)[0].equalsIgnoreCase("c")) {
                        return C2;
                    }
                    return NONE;
                }
                if (string.equals("<")) {
                    return B1;
                }
                return C1;
            }
        }
        ,
        C2{

            @Override
            public BpCmState nextStatus(String string) {
                if (BpCmState.isNoteWithoutR(string)) {
                    return NONE;
                }
                if (string.equals("<")) {
                    return C3;
                }
                return C2;
            }
        }
        ,
        C3{

            @Override
            public String optimize(StringBuilder stringBuilder) {
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("<"));
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(">"));
                return stringBuilder.toString().replace("c", "b+").replace("C", "B+");
            }
        };


        public BpCmState nextStatus(String string) {
            return NONE;
        }

        public String optimize(StringBuilder stringBuilder) {
            throw new AssertionError();
        }

        private static boolean isNoteWithoutR(String string) {
            char c = Character.toLowerCase(string.charAt(0));
            return "abcdefg".indexOf(c) >= 0;
        }
    }
}

