/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.CacheMap;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;
import jp.fourthline.mmlTools.optimizer.NxBpCmOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxOptimizer;

public class OxLxFixedOptimizer
extends OxLxOptimizer {
    private final boolean disableNopt;
    private static final List<FixPattern> pattern = List.of(new FixPattern("32", "r16.", "rrr"), new FixPattern("64", "r32.", "rrr"));

    public OxLxFixedOptimizer(boolean bl) {
        this.disableNopt = bl;
    }

    @Override
    protected void fixPattern(OxLxOptimizer.OptimizerMap optimizerMap) {
        optimizerMap.forEach((string, stringBuilder) -> pattern.stream().forEach(fixPattern -> fixPattern.patternApply((String)string, (StringBuilder)stringBuilder)));
    }

    @Override
    protected void extendPatternBuilder(Map<String, StringBuilder> map, String string, String string2, String string3, int n) {
        int n2 = string.lastIndexOf("l");
        String string4 = "4";
        if (n2 >= 0) {
            string4 = new MMLTokenizer(string.substring(n2)).next().substring(1);
        }
        if (n > 0 && !string4.endsWith(".") && string.endsWith(string2 + "&") && string3.equals((Integer.parseInt(string4) << 1) + ".")) {
            String string5 = "" + (Integer.parseInt(string4) << 2);
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.insert(string.length() - 1, '.');
            map.put(string5, this.newBuilder(OxLxFixedOptimizer.newStringBuilder(map, string5, stringBuilder.toString()), string5, string2, n));
        }
    }

    @Override
    protected OxLxOptimizer.OptimizerMap createOptimizerMap() {
        return new OptimizerMap2();
    }

    public final class OptimizerMap2
    extends OxLxOptimizer.OptimizerMap {
        private static final long serialVersionUID = -1916149376927832458L;
        private static final Map<String, Integer> cache = Collections.synchronizedMap(new CacheMap(8192));

        private static int compString(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            char c;
            char[] cArray;
            char[] cArray2 = stringBuilder.toString().toCharArray();
            int n = Arrays.mismatch(cArray2, cArray = stringBuilder2.toString().toCharArray()) - 1;
            if (n < 0) {
                n = 0;
            }
            while (n > 0 && !MMLTokenizer.isToken(c = cArray2[--n]) && !MMLTokenizer.isNote(c)) {
            }
            return n;
        }

        private static int calcOctave(String string) {
            char[] cArray = string.toCharArray();
            int n = 4;
            block5: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '<': {
                        --n;
                        continue block5;
                    }
                    case '>': {
                        ++n;
                        continue block5;
                    }
                    case 'O': 
                    case 'o': {
                        n = cArray[++i] - 48;
                    }
                }
            }
            return n;
        }

        private static int calcSubNxBpCmOptLength(String string, String string2, int n, boolean bl) {
            int n2 = string.length();
            String string3 = n2 + ":" + string2 + ":" + n + ":" + (bl ? "1" : "0");
            Integer n3 = cache.get(string3);
            if (n3 != null) {
                return n3;
            }
            NxBpCmOptimizer nxBpCmOptimizer = new NxBpCmOptimizer(n, string, bl);
            new MMLTokenizer(string2).forEachRemaining(nxBpCmOptimizer::nextToken);
            int n4 = nxBpCmOptimizer.getMinString().length();
            cache.put(string3, n4);
            return n4;
        }

        @Override
        protected void updateMapMinLength(String string, StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = (StringBuilder)this.get(string);
            if (stringBuilder2 == null) {
                this.put(string, stringBuilder);
            } else {
                int n;
                int n2 = OptimizerMap2.compString(stringBuilder, stringBuilder2);
                int n3 = OptimizerMap2.calcOctave(stringBuilder.substring(0, n2));
                String string2 = stringBuilder.substring(0, n2);
                int n4 = OptimizerMap2.calcSubNxBpCmOptLength(string2, stringBuilder.substring(n2), n3, OxLxFixedOptimizer.this.disableNopt);
                if (n4 < (n = OptimizerMap2.calcSubNxBpCmOptLength(string2, stringBuilder2.substring(n2), n3, OxLxFixedOptimizer.this.disableNopt))) {
                    this.put(string, stringBuilder);
                }
            }
        }

        static {
            MMLStringOptimizer.addCacheList(cache);
        }
    }

    protected static final class FixPattern {
        private final String lStr;
        private final String match;
        private final int matchLen;
        private final String replace;

        protected FixPattern(String string, String string2, String string3) {
            this.lStr = string;
            this.match = string2;
            this.matchLen = string2.length();
            this.replace = string3;
        }

        public void patternApply(String string, StringBuilder stringBuilder) {
            if ((string.equals(this.lStr) || this.lStr.equals("*")) && stringBuilder.toString().endsWith(this.match)) {
                int n = stringBuilder.length();
                int n2 = n - this.matchLen;
                stringBuilder.replace(n2, n, this.replace);
            }
        }
    }
}

