/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import jp.fourthline.mabiicco.midi.InstClass;

public final class Extension3mleTrack {
    private final int instrument;
    private final int panpot;
    private final int startMarker;
    private int trackCount;
    private int trackLimit;
    private final int group;
    private final String trackName;

    public Extension3mleTrack(int n, int n2, int n3, String string, int n4) {
        this.instrument = n;
        this.group = n2;
        this.panpot = n3;
        this.startMarker = n4;
        this.trackName = string;
        this.trackCount = 1;
        this.trackLimit = 0;
        for (boolean bl : InstClass.getEnablePartByProgram(n - 1)) {
            if (!bl) continue;
            ++this.trackLimit;
        }
    }

    public boolean isLimit() {
        return this.trackCount >= this.trackLimit;
    }

    public void addTrack() {
        ++this.trackCount;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public int getGroup() {
        return this.group;
    }

    public int getPanpot() {
        return this.panpot;
    }

    public int getStartMarker() {
        return this.startMarker;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append(this.group).append(" ");
        stringBuilder.append(this.instrument).append(" ");
        stringBuilder.append(this.panpot).append(" ");
        stringBuilder.append(this.trackCount).append(" ");
        stringBuilder.append(this.trackName).append(" ]");
        return stringBuilder.toString();
    }
}

