/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLScoreSerializer;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.ResourceLoader;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.IMMLFileParser;
import jp.fourthline.mmlTools.parser.MMLParseException;

public final class MidiFile
extends AbstractMMLParser {
    private final MMLScore score = new MMLScore();
    private int resolution;
    private static final String PATCH_NAME = "mid_instPatch";
    private static final int MIDI_CHANNEL = 16;
    public static final String PARSE_TRACK_NAME = "parse.midi.trackName";
    public static final String PARSE_BEAT = "parse.midi.beat";
    public static final String PARSE_TEMPO = "parse.midi.tempo";
    public static final String PARSE_MARKER = "parse.midi.marker";
    public static final String PARSE_CONVERT_OCTAVE = "parse.midi.convertOctave";
    public static final String PARSE_CONVERT_INST = "parse.midi.convertInst";
    public static final String PARSE_MULTI_TRACK = "parse.midi.multiTrack";
    public static final String PARSE_ALIGN = "parse.midi.align";
    public static final String PARSE_ALIGN_1 = "parse.midi.align.1";
    public static final String PARSE_ALIGN_2 = "parse.midi.align.2";
    public static final String PARSE_ALIGN_6 = "parse.midi.align.6";
    private final Map<String, Integer> attrMap = new LinkedHashMap<String, Integer>();
    private int parse_align;
    private boolean parseTrackName;
    private boolean parseBeat;
    private boolean parseTempo;
    private boolean parseMarker;
    private boolean parseConvertOctave;
    private boolean parseConvertInst;
    private boolean parseMultiTrack;
    private static boolean canConvertInst = false;
    private final Map<Integer, Integer> midInstTable = new HashMap<Integer, Integer>();
    private final HashMap<Integer, MMLNoteEvent> activeNoteMap = new HashMap();
    private final ArrayList<MMLNoteEvent> curNoteList = new ArrayList();
    private final ArrayList<MMLTempoEvent> tempoList = new ArrayList();

    private void updateOptions() {
        this.parseTrackName = this.parseProperties.getOrDefault(PARSE_TRACK_NAME, false);
        this.parseBeat = this.parseProperties.getOrDefault(PARSE_BEAT, false);
        this.parseTempo = this.parseProperties.getOrDefault(PARSE_TEMPO, false);
        this.parseMarker = this.parseProperties.getOrDefault(PARSE_MARKER, false);
        this.parseConvertOctave = this.parseProperties.getOrDefault(PARSE_CONVERT_OCTAVE, true);
        this.parseConvertInst = this.parseProperties.getOrDefault(PARSE_CONVERT_INST, false);
        this.parseMultiTrack = this.parseProperties.getOrDefault(PARSE_MULTI_TRACK, false);
        System.out.println("parse_align: " + this.parse_align);
    }

    public static void enableInstPatch() {
        canConvertInst = true;
    }

    public MidiFile() {
        this.parseProperties = new LinkedHashMap();
        this.parseProperties.put(PARSE_TRACK_NAME, true);
        this.parseProperties.put(PARSE_BEAT, true);
        this.parseProperties.put(PARSE_TEMPO, true);
        this.parseProperties.put(PARSE_MULTI_TRACK, true);
        this.parseProperties.put(PARSE_MARKER, false);
        if (canConvertInst) {
            this.parseProperties.put(PARSE_CONVERT_OCTAVE, true);
            this.parseProperties.put(PARSE_CONVERT_INST, false);
        }
        this.parse_align = 6;
        this.attrMap.put(PARSE_ALIGN_6, 6);
        this.attrMap.put(PARSE_ALIGN_2, 2);
        this.attrMap.put(PARSE_ALIGN_1, 1);
        this.parseAttributes = new LinkedHashMap();
        this.parseAttributes.put(PARSE_ALIGN, this.attrMap.keySet());
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PATCH_NAME, new ResourceLoader());
            for (String string : resourceBundle.keySet()) {
                String string2 = resourceBundle.getString(string).replaceAll("#.*", "");
                int n = Integer.parseInt(string.trim());
                int n2 = Integer.parseInt(string2.trim());
                System.out.println("[MID-PATCH] " + n + " -> " + n2);
                this.midInstTable.put(n, n2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public MidiFile preparse(File file) {
        try {
            MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(file);
            int n = midiFileFormat.getType();
            System.out.println("type: " + n);
            Track[] trackArray = MidiSystem.getSequence(file).getTracks();
            if (n == 0) {
                this.trackSelectMap = this.preparseChannel(trackArray[0]);
            } else if (n == 1) {
                this.trackSelectMap = new LinkedHashMap();
                for (int i = 0; i < trackArray.length; ++i) {
                    IMMLFileParser.TrackSelect trackSelect = this.preparseTrack(trackArray[i], i);
                    if (trackSelect == null) continue;
                    this.trackSelectMap.put(i, trackSelect);
                }
            } else {
                System.out.println("not support format <" + n + ">");
            }
            System.out.println(this.trackSelectMap);
        }
        catch (IOException | InvalidMidiDataException exception) {
            exception.printStackTrace();
        }
        return this;
    }

    private Map<Integer, IMMLFileParser.TrackSelect> preparseChannel(Track track) {
        int n = track.size();
        boolean[] blArray = new boolean[16];
        Arrays.fill(blArray, false);
        for (int i = 0; i < n; ++i) {
            ShortMessage shortMessage;
            MidiMessage midiMessage = track.get(i).getMessage();
            if (!(midiMessage instanceof ShortMessage) || (shortMessage = (ShortMessage)midiMessage).getCommand() != 144) continue;
            blArray[shortMessage.getChannel()] = true;
        }
        LinkedHashMap<Integer, IMMLFileParser.TrackSelect> linkedHashMap = new LinkedHashMap<Integer, IMMLFileParser.TrackSelect>();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            linkedHashMap.put(i, new IMMLFileParser.TrackSelect(new TrackInfo((int)i).name));
        }
        return linkedHashMap;
    }

    private IMMLFileParser.TrackSelect preparseTrack(Track track, int n) {
        String string = new TrackInfo((int)n).name;
        int n2 = track.size();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            ShortMessage shortMessage;
            MidiMessage midiMessage = track.get(i).getMessage();
            if (midiMessage instanceof MetaMessage) {
                MetaMessage metaMessage = (MetaMessage)midiMessage;
                if (metaMessage.getType() == 3 && metaMessage.getData().length > 0) {
                    string = new String(metaMessage.getData());
                    bl = true;
                }
            } else if (midiMessage instanceof ShortMessage && (shortMessage = (ShortMessage)midiMessage).getCommand() == 144 && !bl2) {
                bl2 = true;
            }
            if (bl && bl2) break;
        }
        return bl2 ? new IMMLFileParser.TrackSelect(string) : null;
    }

    @Override
    public String getName() {
        return "MIDI";
    }

    @Override
    public MMLScore parse(InputStream inputStream) throws MMLParseException {
        block11: {
            this.updateOptions();
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(bufferedInputStream);
                int n = midiFileFormat.getType();
                System.out.println("type: " + n);
                bufferedInputStream.reset();
                Sequence sequence = MidiSystem.getSequence(bufferedInputStream);
                this.resolution = sequence.getResolution();
                System.out.println(sequence.getTracks().length);
                System.out.println("resolution: " + this.resolution);
                System.out.println(sequence.getDivisionType());
                System.out.println(sequence.getMicrosecondLength());
                System.out.println(sequence.getTickLength());
                if (n == 0) {
                    this.parseFormat0Track(sequence.getTracks()[0]);
                    break block11;
                }
                if (n == 1) {
                    this.parseFormat1Track(sequence.getTracks());
                    break block11;
                }
                throw new MMLParseException("not support format <" + n + ">");
            }
            catch (IOException | InvalidMidiDataException exception) {
                exception.printStackTrace();
            }
        }
        this.score.getTempoEventList().addAll(this.tempoList);
        try {
            return this.score.generateAll();
        }
        catch (MMLExceptionList | MMLVerifyException exception) {
            return this.score;
        }
    }

    private List<MidiEvent> convMidiEventList(Track track) {
        ArrayList<MidiEvent> arrayList = new ArrayList<MidiEvent>(track.size());
        for (int i = 0; i < track.size(); ++i) {
            arrayList.add(track.get(i));
        }
        return arrayList;
    }

    private void parseFormat0Track(Track track) throws MMLParseException {
        List<MidiEvent> list = this.convMidiEventList(track);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 16; ++i) {
            arrayList.add(new ArrayList());
        }
        TrackInfo trackInfo = new TrackInfo(0);
        for (MidiEvent iterator : list) {
            Object object = iterator.getMessage();
            long l = this.convTick(iterator.getTick());
            if (l >= 3840000L) continue;
            if (object instanceof MetaMessage) {
                this.parseMetaMessage((MetaMessage)object, l, trackInfo);
                continue;
            }
            if (object instanceof ShortMessage) {
                ShortMessage shortMessage = (ShortMessage)object;
                int n = shortMessage.getChannel();
                ((List)arrayList.get(n)).add(iterator);
                continue;
            }
            if (object instanceof SysexMessage) {
                System.out.println("Sysex");
                continue;
            }
            throw new MMLParseException("Unknown MIDI message.");
        }
        for (int i = 0; i < 16; ++i) {
            IMMLFileParser.TrackSelect trackSelect;
            if (this.trackSelectMap != null && (trackSelect = (IMMLFileParser.TrackSelect)this.trackSelectMap.get(i)) != null && !trackSelect.isEnabled()) continue;
            this.activeNoteMap.clear();
            this.curNoteList.clear();
            trackInfo = new TrackInfo(i);
            for (Object object : (List)arrayList.get(i)) {
                MidiMessage midiMessage = ((MidiEvent)object).getMessage();
                long l = this.convTick(((MidiEvent)object).getTick());
                if (l >= 3840000L || !(midiMessage instanceof ShortMessage)) continue;
                ShortMessage shortMessage = (ShortMessage)midiMessage;
                this.parseShortMessage(shortMessage, l, trackInfo);
            }
            this.createMMLTrack(this.createMMLEventList(), trackInfo);
        }
    }

    private void parseFormat1Track(Track[] trackArray) throws MMLParseException {
        for (int i = 0; i < trackArray.length; ++i) {
            Object object;
            System.out.println(" - track -");
            System.out.println(trackArray[i].size());
            if (this.trackSelectMap != null && (object = (IMMLFileParser.TrackSelect)this.trackSelectMap.get(i)) != null && !((IMMLFileParser.TrackSelect)object).isEnabled()) continue;
            object = new TrackInfo(i);
            this.activeNoteMap.clear();
            this.curNoteList.clear();
            for (MidiEvent midiEvent : this.convMidiEventList(trackArray[i])) {
                MidiMessage midiMessage = midiEvent.getMessage();
                long l = this.convTick(midiEvent.getTick());
                if (l >= 3840000L) continue;
                if (midiMessage instanceof MetaMessage) {
                    this.parseMetaMessage((MetaMessage)midiMessage, l, (TrackInfo)object);
                    continue;
                }
                if (midiMessage instanceof ShortMessage) {
                    this.parseShortMessage((ShortMessage)midiMessage, l, (TrackInfo)object);
                    continue;
                }
                if (midiMessage instanceof SysexMessage) {
                    System.out.println("Sysex");
                    continue;
                }
                throw new MMLParseException("Unknown MIDI message.");
            }
            this.createMMLTrack(this.createMMLEventList(), (TrackInfo)object);
        }
    }

    private void createMMLTrack(ArrayList<MMLEventList> arrayList, TrackInfo trackInfo) throws MMLParseException {
        System.out.printf(" ###### track tick: %d %d => %d\n", this.activeNoteMap.size(), this.curNoteList.size(), arrayList.size());
        try {
            while (arrayList.size() > 0) {
                String[] stringArray = new String[3];
                ArrayList<MMLEventList> arrayList2 = new ArrayList<MMLEventList>();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!arrayList.isEmpty()) {
                        MMLEventList mMLEventList = arrayList.get(0);
                        arrayList2.add(mMLEventList);
                        stringArray[i] = new MMLStringOptimizer(mMLEventList.getInternalMMLString()).toString();
                        arrayList.remove(0);
                        continue;
                    }
                    stringArray[i] = "";
                }
                MMLTrack mMLTrack = trackInfo.createMMLTrack();
                mMLTrack.setMML(stringArray[0], stringArray[1], stringArray[2], "");
                if (trackInfo.program == InstClass.DRUM) {
                    mMLTrack.setImportedData(MMLScoreSerializer.toStringImportedData(arrayList2));
                }
                if (this.score.addTrack(mMLTrack) < 0) {
                    throw new MMLParseException("track over: " + mMLTrack.getTrackName());
                }
                if (this.parseMultiTrack) continue;
                break;
            }
        }
        catch (MMLExceptionList mMLExceptionList) {
            mMLExceptionList.printStackTrace();
        }
    }

    private ArrayList<MMLEventList> createMMLEventList() {
        ArrayList<MMLEventList> arrayList = new ArrayList<MMLEventList>();
        for (MMLNoteEvent mMLNoteEvent : this.curNoteList) {
            for (MMLEventList mMLEventList2 : arrayList) {
                if (mMLEventList2.isOverlapNote(mMLNoteEvent)) continue;
                mMLEventList2.addMMLNoteEvent(mMLNoteEvent);
                mMLNoteEvent = null;
                break;
            }
            if (mMLNoteEvent == null) continue;
            MMLEventList mMLEventList3 = new MMLEventList("");
            mMLEventList3.addMMLNoteEvent(mMLNoteEvent);
            arrayList.add(mMLEventList3);
        }
        arrayList.forEach(mMLEventList -> mMLEventList.deleteMinRest());
        return arrayList;
    }

    private void parseMetaMessage(MetaMessage metaMessage, long l, TrackInfo trackInfo) {
        int n = metaMessage.getType();
        byte[] byArray = metaMessage.getData();
        switch (n) {
            case 81: {
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                byteBuffer.put((byte)0);
                byteBuffer.put(byArray);
                int n2 = 60000000 / byteBuffer.getInt(0);
                if (!this.parseTempo) break;
                new MMLTempoEvent(n2, (int)l).appendToListElement(this.tempoList);
                break;
            }
            case 3: {
                String string = new String(byArray);
                System.out.println("Name: " + string);
                if (!this.parseTrackName) break;
                trackInfo.setName(string);
                break;
            }
            case 1: {
                System.out.println("Text: " + new String(byArray));
                break;
            }
            case 2: {
                System.out.println("(C): " + new String(byArray));
                break;
            }
            case 6: {
                String string = new String(byArray);
                System.out.println("Marker: " + string);
                if (!this.parseMarker) break;
                this.score.getMarkerList().add(new Marker(string, (int)l));
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                System.out.println("Text(" + n + "): " + new String(byArray));
                break;
            }
            case 88: {
                System.out.printf("met: %d %d %d %d\n", byArray[0], 1 << byArray[1], byArray[2], byArray[3]);
                if (!this.parseBeat) break;
                int n3 = 1 << byArray[1];
                byte by = byArray[0];
                if (n3 > 32 || by <= 0 || by > 32) break;
                if (l == 0L) {
                    this.score.setBaseOnly(n3);
                    this.score.setTimeCountOnly(by);
                    break;
                }
                try {
                    this.score.addTimeSignature(new TimeSignature(this.score, (int)l, by, n3));
                }
                catch (MMLException mMLException) {
                    mMLException.printStackTrace();
                }
                break;
            }
            case 89: {
                System.out.printf("sig: %d %d\n", byArray[0], byArray[1]);
                break;
            }
            default: {
                System.out.printf("Meta: [%x] [%d]\n", n, byArray.length);
            }
        }
    }

    private int convertMidiNote(TrackInfo trackInfo, int n) {
        if (trackInfo.program != InstClass.DRUM) {
            n -= this.parseConvertOctave ? 12 : 0;
        }
        return n;
    }

    private void parseShortMessage(ShortMessage shortMessage, long l, TrackInfo trackInfo) throws MMLParseException {
        int n = shortMessage.getCommand();
        int n2 = shortMessage.getChannel();
        int n3 = shortMessage.getData1();
        int n4 = shortMessage.getData2();
        switch (n) {
            case 176: {
                if (n3 != 10) break;
                trackInfo.panpot = n4;
                break;
            }
            case 144: {
                if (n4 > 0) {
                    int n5 = this.convertMidiNote(trackInfo, n3);
                    int n6 = n4 / 8;
                    if (this.activeNoteMap.containsKey(n5)) break;
                    MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(n5, 0, (int)l, n6);
                    try {
                        mMLNoteEvent.toMMLString();
                    }
                    catch (MMLException mMLException) {
                        break;
                    }
                    this.activeNoteMap.put(n5, mMLNoteEvent);
                    this.curNoteList.add(mMLNoteEvent);
                    break;
                }
            }
            case 128: {
                int n7 = this.convertMidiNote(trackInfo, n3);
                MMLNoteEvent mMLNoteEvent = this.activeNoteMap.get(n7);
                if (mMLNoteEvent == null) break;
                if ((l -= (long)mMLNoteEvent.getTickOffset()) < (long)MMLTicks.minimumTick()) {
                    l = MMLTicks.minimumTick();
                }
                mMLNoteEvent.setTick((int)l);
                this.activeNoteMap.remove(n7);
                break;
            }
            case 192: {
                System.out.printf("program change: [%d] [%d] (%d)\n", n3, n4, n2);
                if (n2 == 9) {
                    trackInfo.setProgram(InstClass.DRUM);
                    break;
                }
                if (!canConvertInst) {
                    trackInfo.setProgram(n3);
                    break;
                }
                if (!this.parseConvertInst || !this.midInstTable.containsKey(n3)) break;
                n3 = this.midInstTable.get(n3);
                trackInfo.setProgram(n3);
                System.out.println("   -> " + n3);
                break;
            }
            default: {
                System.out.printf("short: [%x] [%d] [%d] [%d]\n", n, n2, n3, n4);
            }
        }
    }

    private long convTick(long l) {
        long l2 = l * 96L / (long)this.resolution;
        if (this.parse_align > 1) {
            l2 += (long)(this.parse_align / 2);
            l2 -= l2 % (long)this.parse_align;
        }
        return l2;
    }

    @Override
    public void setParseAttribute(String string, String string2) {
        System.out.println("setParseAttribute " + string + ":" + string2);
        if (string == PARSE_ALIGN) {
            this.parse_align = this.attrMap.get(string2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            MMLScore mMLScore = new MidiFile().parse(new FileInputStream("sample2.mid"));
            mMLScore.generateAll();
        }
        catch (FileNotFoundException | MMLExceptionList | MMLVerifyException | MMLParseException exception) {
            exception.printStackTrace();
        }
    }

    private static final class TrackInfo {
        private String name;
        private int panpot = 64;
        private int program = 0;

        private TrackInfo(int n) {
            this.name = "Track" + (n + 1);
        }

        private MMLTrack createMMLTrack() {
            InstClass[] instClassArray;
            MMLTrack mMLTrack = new MMLTrack();
            mMLTrack.setTrackName(this.name);
            mMLTrack.setPanpot(this.panpot);
            int n = this.program;
            if (this.program == InstClass.DRUM && ((SoundEnv)MabiIccoProperties.getInstance().soundEnv.get()).useDLS() && (instClassArray = MabiDLS.getInstance().getAvailableInstByInstType(List.of(InstType.DRUMS))).length > 0) {
                n = instClassArray[0].getProgram();
            }
            mMLTrack.setProgram(n);
            return mMLTrack;
        }

        private void setName(String string) {
            if (string != null && string.length() > 0) {
                this.name = string;
            }
        }

        private void setProgram(int n) {
            this.program = n;
        }
    }
}

