/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleConsumer;
import java.util.stream.Collectors;
import jp.fourthline.mabiicco.midi.InstClass;

public final class DLSLoader
implements Comparator<File> {
    private final List<File> fileList;
    private static final List<String> priorityList = List.of("MSXspirit01.dls", "MSXspirit02.dls", "MSXspirit03.dls", "MSXspirit04.dls");
    public static boolean noParallel = false;
    public static final int DLS_LOAD_LIMIT = 64;

    public DLSLoader(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            File file2 = this.fixFile(file);
            if (arrayList.contains(file2) || !file2.exists()) continue;
            if (arrayList.size() >= 64) break;
            arrayList.add(file2);
        }
        Collections.sort(arrayList, this);
        this.fileList = Collections.unmodifiableList(arrayList);
    }

    public List<File> getFileList() {
        return this.fileList;
    }

    @Override
    public int compare(File file, File file2) {
        String string = file.getName();
        String string2 = file2.getName();
        if (priorityList.contains(string) && priorityList.contains(string2)) {
            return Integer.compare(priorityList.indexOf(string), priorityList.indexOf(string2));
        }
        if (priorityList.contains(string)) {
            return -1;
        }
        if (priorityList.contains(string2)) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private File fixFile(File file) {
        if (!file.exists()) {
            for (Path path : FileSystems.getDefault().getRootDirectories()) {
                File file2 = new File(path.toString() + file.getPath());
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
        }
        return file;
    }

    private List<List<InstClass>> fileLoad(DoubleConsumer doubleConsumer) {
        ArrayList<PInputStream> arrayList = new ArrayList<PInputStream>();
        this.fileList.forEach(file -> arrayList.add(this.startLoad((File)file)));
        CompletableFuture[] completableFutureArray = (CompletableFuture[])arrayList.stream().filter(pInputStream -> pInputStream != null).map(pInputStream -> pInputStream.cf).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(completableFutureArray);
        int n = PInputStream.sumTotal(arrayList);
        while (!completableFuture.isDone()) {
            this.updateProgress(PInputStream.sumCurrent(arrayList), n, doubleConsumer);
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.updateProgress(PInputStream.sumCurrent(arrayList), n, doubleConsumer);
        return arrayList.stream().filter(pInputStream -> pInputStream != null).map(pInputStream -> pInputStream.cf.join()).collect(Collectors.toList());
    }

    private PInputStream startLoad(File file) {
        try {
            PInputStream pInputStream = new PInputStream(file);
            if (noParallel) {
                pInputStream.cf.join();
            }
            return pInputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void updateProgress(int n, int n2, DoubleConsumer doubleConsumer) {
        if (doubleConsumer != null && n2 > 0) {
            double d = (double)n / (double)n2;
            doubleConsumer.accept(d);
        }
    }

    public List<File> load(DoubleConsumer doubleConsumer, List<InstClass> list, Map<File, List<InstClass>> map) throws IOException {
        List<List<InstClass>> list2 = this.fileLoad(doubleConsumer);
        list.clear();
        map.clear();
        int n = this.fileList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<InstClass> arrayList;
            List<InstClass> list3 = list2.get(i);
            if (list3 != null) {
                arrayList = new ArrayList<InstClass>();
                for (InstClass instClass : list3) {
                    if (list.contains(instClass)) continue;
                    list.add(instClass);
                    arrayList.add(instClass);
                }
            } else {
                throw new IOException("load failed: " + this.fileList.get(i).getName());
            }
            map.put(this.fileList.get(i), arrayList);
        }
        return this.fileList;
    }

    private static class PInputStream
    extends BufferedInputStream {
        private final int total = this.available() >> 10;
        private int current = 0;
        private final File f;
        private CompletableFuture<List<InstClass>> cf;

        private static int sumTotal(List<PInputStream> list) {
            return list.stream().filter(pInputStream -> pInputStream != null).mapToInt(pInputStream -> pInputStream.total).sum();
        }

        private static int sumCurrent(List<PInputStream> list) {
            return list.stream().filter(pInputStream -> pInputStream != null).mapToInt(pInputStream -> pInputStream.current).sum();
        }

        public PInputStream(File file) throws IOException {
            super(new FileInputStream(file), 65536);
            this.f = file;
            this.cf = CompletableFuture.supplyAsync(() -> {
                try {
                    List<InstClass> list = InstClass.loadDLS(this, this.f.getName());
                    this.close();
                    this.current = this.total;
                    return list;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            });
            System.out.println("[ " + this.f.getName() + " ]");
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            int n2 = this.total - (this.available() >> 10);
            this.current = Math.max(this.current, n2);
            return n;
        }
    }
}

