/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IEditState;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.MainView;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mmlTools.MMLScore;

public final class PianoRollScaler
implements MouseWheelListener {
    private final IMMLManager mmlManager;
    private final PianoRollView pianoRollView;
    private final JScrollPane scrollPane;
    private final MainView parent;
    private final IEditState editState;
    private int viewScaleIndex = 0;
    private final double[] viewScaleTable = new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.5, 1.0, 0.75, 0.5, 0.375, 0.25, 0.1};
    private final List<JScrollPane> scrollPaneList = new ArrayList<JScrollPane>();
    private final List<ChangeScaleListener> repositionNotify = new ArrayList<ChangeScaleListener>();

    public PianoRollScaler(IMMLManager iMMLManager, PianoRollView pianoRollView, JScrollPane jScrollPane, MainView mainView, IEditState iEditState) {
        this.mmlManager = iMMLManager;
        this.pianoRollView = pianoRollView;
        this.scrollPane = jScrollPane;
        this.parent = mainView;
        this.editState = iEditState;
    }

    public void addScrollPane(JScrollPane jScrollPane) {
        this.scrollPaneList.add(jScrollPane);
        jScrollPane.addMouseWheelListener(this);
        jScrollPane.setWheelScrollingEnabled(false);
    }

    public double getScale() {
        return this.viewScaleTable[this.viewScaleIndex];
    }

    public void expandPianoViewWide() {
        this.scalePlayPosition(n -> this.expandPianoViewWide(n));
    }

    public void reducePianoViewWide() {
        this.scalePlayPosition(n -> this.reducePianoViewWide(n));
    }

    private void scalePlayPosition(IntConsumer intConsumer) {
        int n = 0;
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            double d = this.pianoRollView.getWideScale();
            long l = this.pianoRollView.getSequencePlayPosition();
            int n2 = this.scrollPane.getViewport().getViewPosition().x;
            n = (int)((double)l / d) - n2;
        }
        intConsumer.accept(n);
    }

    public void expandPianoViewWide(int n) {
        if (this.viewScaleIndex + 1 < this.viewScaleTable.length) {
            ++this.viewScaleIndex;
            this.updatePianoViewWide(n);
        }
    }

    public void reducePianoViewWide(int n) {
        if (this.viewScaleIndex - 1 >= 0) {
            --this.viewScaleIndex;
            this.updatePianoViewWide(n);
        }
    }

    private void updatePianoViewWide(int n) {
        double d = this.pianoRollView.getWideScale();
        this.pianoRollView.setWideScale(this.viewScaleTable[this.viewScaleIndex]);
        this.repositionChangeScaleView(d, this.pianoRollView.getWideScale(), n);
    }

    private void repositionChangeScaleView(double d, double d2, int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        point.x = (int)((double)(point.x + n) * d / d2) - n;
        this.parent.repaint();
        this.scrollPaneList.forEach(jScrollPane -> jScrollPane.getViewport().updateUI());
        jViewport.setViewPosition(point);
        this.repositionNotify.forEach(changeScaleListener -> changeScaleListener.changeScale(point.x + n));
        UIUtils.viewportSetPositionWorkaround(jViewport, point);
    }

    public void addChangeScaleListener(ChangeScaleListener changeScaleListener) {
        this.repositionNotify.add(changeScaleListener);
    }

    private void scrollH(int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        int n2 = ((MouseScrollWidth)MabiIccoProperties.getInstance().mouseScrollWidth.get()).getDelta(mMLScore, jViewport, this.pianoRollView);
        point.x = point.x + (n > 0 ? n2 : -n2);
        point.x = Math.min(Math.max(0, point.x), this.pianoRollView.getWidth() - jViewport.getWidth());
        jViewport.setViewPosition(point);
        UIUtils.viewportSetPositionWorkaround(jViewport, point);
        this.parent.repaint();
    }

    private void scrollV(int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n2 = this.pianoRollView.getNoteHeight() * 2;
        point.y = point.y + (n > 0 ? n2 : -n2);
        point.y = Math.min(Math.max(0, point.y + (n > 0 ? n2 : -n2)), this.pianoRollView.getHeight() - jViewport.getHeight());
        jViewport.setViewPosition(point);
        this.parent.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        Object object = mouseWheelEvent.getSource();
        if (object instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)object;
            int n2 = mouseWheelEvent.getX() - jScrollPane.getViewport().getBounds().x;
            if (mouseWheelEvent.isAltDown() && !mouseWheelEvent.isControlDown() && !mouseWheelEvent.isShiftDown()) {
                this.editState.notesModifyVelocity(mouseWheelEvent.getPoint(), n < 0);
            } else if (!mouseWheelEvent.isAltDown() && mouseWheelEvent.isControlDown() && !mouseWheelEvent.isShiftDown()) {
                if (n < 0) {
                    this.expandPianoViewWide(n2);
                } else {
                    this.reducePianoViewWide(n2);
                }
            } else if (!mouseWheelEvent.isAltDown() && !mouseWheelEvent.isControlDown() && mouseWheelEvent.isShiftDown()) {
                this.scrollH(n);
            } else {
                this.scrollV(n);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MouseScrollWidth implements SettingButtonGroupItem
    {
        AUTO{

            @Override
            public int getDelta(MMLScore mMLScore, JViewport jViewport, PianoRollView pianoRollView) {
                int n = pianoRollView.convertTicktoX(mMLScore.getMeasureTick());
                int n2 = jViewport.getWidth();
                if (n2 > n) {
                    return pianoRollView.convertTicktoX(n2 > n * 2 ? (long)mMLScore.getMeasureTick() : (long)mMLScore.getBeatTick());
                }
                return 6;
            }
        }
        ,
        MEASURE{

            @Override
            public int getDelta(MMLScore mMLScore, JViewport jViewport, PianoRollView pianoRollView) {
                return pianoRollView.convertTicktoX(mMLScore.getMeasureTick());
            }
        }
        ,
        BEAT{

            @Override
            public int getDelta(MMLScore mMLScore, JViewport jViewport, PianoRollView pianoRollView) {
                return pianoRollView.convertTicktoX(mMLScore.getBeatTick());
            }
        }
        ,
        FIX6{

            @Override
            public int getDelta(MMLScore mMLScore, JViewport jViewport, PianoRollView pianoRollView) {
                return 6;
            }
        };

        private static final int FIXW = 6;
        private final String name = AppResource.appText("ui.mouse_scroll_width." + super.name().toLowerCase());

        @Override
        public String getButtonName() {
            return this.name;
        }

        public abstract int getDelta(MMLScore var1, JViewport var2, PianoRollView var3);
    }

    public static interface ChangeScaleListener {
        public void changeScale(int var1);
    }
}

