/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IEditStateObserver;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.Utils;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.RangeMode;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLScoreSerializer;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.ResourceLoader;
import jp.fourthline.mmlTools.parser.MMLEventParser;

public final class DrumConverter {
    private final Map<KeyMap, KeyMap> defaultMap = new HashMap<KeyMap, KeyMap>();
    private final Map<KeyMap, KeyMap> drumMap = new HashMap<KeyMap, KeyMap>();
    private final Map<Integer, KeyMap> mabiMap = new TreeMap<Integer, KeyMap>();
    private final Map<Integer, KeyMap> midMap = new TreeMap<Integer, KeyMap>();
    private static final String X_NOTE = "O3D";
    private static final String X_NAME = "Snare ghost";
    public static final RangeMode[] modes = RangeMode.values();
    private static DrumConverter instance = null;
    private final InstClass inst = MabiDLS.getInstance().getAvailableInstByInstType(List.of(InstType.DRUMS))[0];
    private JDialog dialog = null;

    public static DrumConverter getInstance() {
        if (instance == null) {
            instance = new DrumConverter();
        }
        return instance;
    }

    private DrumConverter() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("midDrum_mabiDrum", new ResourceLoader());
        resourceBundle.keySet().stream().sorted().forEach(string -> {
            String string2 = resourceBundle.getString((String)string);
            String[] stringArray = string2.split("\t");
            String string3 = "O" + stringArray[2] + stringArray[3].replace("b", "-").replace("#", "+");
            KeyMap keyMap = new KeyMap((String)string, stringArray[0], null);
            KeyMap keyMap2 = new KeyMap(string3, stringArray[4], this.inst);
            if (this.mabiMap.containsKey(keyMap2.key)) {
                keyMap2 = this.mabiMap.get(keyMap2.key);
            } else {
                this.mabiMap.put(keyMap2.key, keyMap2);
            }
            if (!this.midMap.containsKey(keyMap.key)) {
                this.drumMap.put(keyMap, keyMap2);
                this.midMap.put(keyMap.key, keyMap);
            }
        });
        KeyMap keyMap = new KeyMap(X_NOTE, X_NAME, null);
        if (!this.mabiMap.containsKey(keyMap.key)) {
            this.mabiMap.put(keyMap.key, keyMap);
        }
        this.drumMap.put(null, keyMap);
        this.defaultMap.putAll(this.drumMap);
        List<String> list = List.of("C", "C+", "D", "D+", "E", "F", "F+", "G", "G+", "A", "A+", "B");
        for (int i = 2; i < 7; ++i) {
            for (String string2 : list) {
                KeyMap keyMap2 = new KeyMap("O" + i + string2, "<UNKNOWN>", this.inst);
                if (this.mabiMap.containsKey(keyMap2.key)) continue;
                if (keyMap2.name.isPresent()) {
                    throw new IllegalStateException("unknown: " + list);
                }
                this.mabiMap.put(keyMap2.key, keyMap2);
            }
        }
        this.loadData();
    }

    public static boolean isDrumTrack(MMLTrack mMLTrack) {
        if (mMLTrack == null) {
            return false;
        }
        InstType instType = MabiDLS.getInstance().getInstByProgram(mMLTrack.getProgram()).getType();
        if (instType == InstType.DRUMS) {
            return mMLTrack.getImportedData() != null;
        }
        return false;
    }

    public static boolean containsDrumTrack(MMLScore mMLScore) {
        boolean bl = false;
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            if (!DrumConverter.isDrumTrack(mMLTrack)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean convert(IMMLManager iMMLManager, int n, int n2) {
        boolean bl = false;
        MMLTrack mMLTrack = iMMLManager.getMMLScore().getTrack(n);
        if (!DrumConverter.isDrumTrack(mMLTrack)) {
            return false;
        }
        List<MMLEventList> list = MMLScoreSerializer.parseImportedData(mMLTrack.getImportedData());
        if (list == null) {
            return false;
        }
        MMLEventList mMLEventList = mMLTrack.getMMLEventAtIndex(n2);
        if (n2 < list.size()) {
            MMLEventList mMLEventList2 = list.get(n2);
            for (MMLNoteEvent mMLNoteEvent : mMLEventList2.getMMLNoteEventList()) {
                int n3 = mMLNoteEvent.getTickOffset();
                MMLNoteEvent mMLNoteEvent2 = mMLEventList.searchOnTickOffset(n3);
                if (mMLNoteEvent2.getTickOffset() != n3 || mMLNoteEvent2.getTick() != mMLNoteEvent.getTick()) continue;
                KeyMap keyMap = this.midMap.get(mMLNoteEvent.getNote());
                KeyMap keyMap2 = this.drumMap.get(keyMap);
                if (mMLNoteEvent2.getNote() == keyMap2.key) continue;
                mMLNoteEvent2.setNote(keyMap2.key);
                bl = true;
            }
        }
        return bl;
    }

    public void midDrum2MabiDrum(IMMLManager iMMLManager, RangeMode rangeMode) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        rangeMode.action(iMMLManager, (n, n2) -> {
            if (this.convert(iMMLManager, n, n2)) {
                atomicBoolean.set(true);
            }
        });
        if (atomicBoolean.get()) {
            iMMLManager.updateActivePart(true);
        }
    }

    private void saveData() {
        Properties properties = new Properties();
        this.defaultMap.forEach((keyMap, keyMap2) -> {
            KeyMap keyMap3 = this.drumMap.get(keyMap);
            if (!keyMap2.equals(keyMap3)) {
                int n = Integer.MIN_VALUE;
                if (keyMap != null) {
                    n = keyMap.key;
                }
                properties.setProperty(Integer.toString(n), Integer.toString(keyMap3.key));
            }
        });
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        MabiIccoProperties.getInstance().drumConvertCustomMap.set(Utils.compress(byteArrayOutputStream.toString()));
    }

    private void loadData() {
        String string = (String)MabiIccoProperties.getInstance().drumConvertCustomMap.get();
        if (string.length() == 0) {
            return;
        }
        byte[] byArray = Utils.decompress(string);
        if (byArray == null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Properties properties = new Properties();
        try {
            properties.load(byteArrayInputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
                if (object instanceof String) {
                    String string = (String)object;
                    if (object2 instanceof String) {
                        String string2 = (String)object2;
                        int n = Integer.parseInt(string);
                        int n2 = Integer.parseInt(string2);
                        KeyMap keyMap = n == Integer.MIN_VALUE ? null : this.midMap.get(n);
                        KeyMap keyMap2 = this.mabiMap.get(n2);
                        this.drumMap.put(keyMap, keyMap2);
                    }
                }
            }));
        }
        catch (IOException | NumberFormatException exception) {
            exception.printStackTrace();
            this.saveData();
        }
    }

    public void showConvertMap(Frame frame, IMMLManager iMMLManager) {
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, AppResource.appText("edit.drum_convert"));
            Editor editor = new Editor(this.dialog, iMMLManager);
            this.dialog.add(editor);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    DrumConverter.this.dialog.setVisible(false);
                }
            });
            this.dialog.setLocationRelativeTo(frame);
            ActionDispatcher.getInstance().addEditObserber(editor);
        }
        this.dialog.setVisible(true);
    }

    private static class KeyMap
    implements Comparable<KeyMap> {
        private final int key;
        private final String keyName;
        private final Optional<String> name;

        private KeyMap(String string, String string2, InstClass instClass) {
            if (string.startsWith("O")) {
                this.key = MMLEventParser.firstNoteNumber(string);
                this.keyName = string;
            } else {
                this.key = Integer.parseInt(string);
                this.keyName = "#" + string + "/" + MMLNoteEvent.keyToAbsNote(this.key);
            }
            this.name = instClass == null || instClass.isValid(this.key) ? Optional.of(string2) : Optional.empty();
        }

        public String getName() {
            if (this.name.isPresent()) {
                return this.name.get();
            }
            return "-";
        }

        public int hashCode() {
            return this.key;
        }

        @Override
        public int compareTo(KeyMap keyMap) {
            return this.key - keyMap.key;
        }

        public String toString() {
            Object object = this.keyName;
            if (this.name.isPresent()) {
                object = (String)object + ": " + this.name.get();
            }
            return object;
        }
    }

    public static class Editor
    extends JPanel
    implements ActionListener,
    IEditStateObserver {
        private static final long serialVersionUID = -7937826516875634485L;
        private final JComboBox<KeyMap> combo = new JComboBox();
        private final JLabel midLabel = new JLabel();
        private final JLabel mabiLabel = new JLabel();
        private final DrumConverter c = DrumConverter.getInstance();
        private final JTable table;
        private final JComboBox<SettingButtonGroupItem.SettingButtonItem> modeCombo;
        private final JButton execButton = new JButton(AppResource.appText("drum_convert.convert"));
        private final JButton closeButton = new JButton(AppResource.appText("drum_convert.close"));
        private final JDialog dialog;
        private final IMMLManager mmlManager;
        private final List<KeyMap> keyList = new ArrayList<KeyMap>();

        private String mabiName(KeyMap keyMap, KeyMap keyMap2) {
            boolean bl = this.c.defaultMap.get((Object)keyMap).key == keyMap2.key;
            Object object = keyMap2.getName();
            if (!bl) {
                object = (String)object + "  (*)";
            }
            return object;
        }

        private KeyMap getKeyMap(int n) {
            KeyMap keyMap = null;
            if (n >= 0 && n < this.keyList.size()) {
                keyMap = this.keyList.get(n);
            }
            return keyMap;
        }

        private Editor(JDialog jDialog, IMMLManager iMMLManager) {
            super(new BorderLayout());
            this.dialog = jDialog;
            this.mmlManager = iMMLManager;
            ImageIcon imageIcon = AppResource.getImageIcon(AppResource.appText("drum_convert.sound_icon"));
            Vector<Vector<String>> vector = new Vector<Vector<String>>();
            this.c.midMap.forEach((n, keyMap) -> {
                KeyMap keyMap2 = keyMap;
                KeyMap keyMap3 = this.c.drumMap.get(keyMap);
                vector.add(new Vector<String>(List.of(keyMap2.keyName, keyMap2.getName(), keyMap3.keyName, this.mabiName(keyMap2, keyMap3))));
                this.keyList.add(keyMap2);
            });
            KeyMap keyMap2 = this.c.drumMap.get(null);
            vector.add(new Vector<String>(List.of("-", "-", keyMap2.keyName, this.mabiName(null, keyMap2))));
            this.table = UIUtils.createTable(vector, new Vector<String>(List.of("GM key", "GM name", "Mabi key", "Mabi name")));
            this.table.getColumnModel().getColumn(0).setMinWidth(100);
            this.table.getColumnModel().getColumn(0).setMaxWidth(100);
            this.table.getColumnModel().getColumn(2).setMinWidth(100);
            this.table.getColumnModel().getColumn(2).setMaxWidth(100);
            this.table.setRowSelectionAllowed(true);
            this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.updateCombo(false));
            this.combo.setEnabled(false);
            JPanel jPanel = UIUtils.createTitledPanel("drum_convert.map_change", new BorderLayout());
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton(AppResource.appText("edit.default"));
            jButton.addActionListener(actionEvent -> this.setDefaultMabiKey());
            JButton jButton2 = new JButton(AppResource.appText("edit.apply"));
            jButton2.addActionListener(actionEvent -> this.selectedMabiKey(true));
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)new JLabel("MIDI: "), "West");
            jPanel3.add((Component)this.midLabel, "Center");
            JButton jButton3 = new JButton(imageIcon);
            jButton3.setFocusable(false);
            jButton3.addMouseListener(new DMouseListener(null, () -> this.selectedMidKey()));
            jPanel3.add((Component)jButton3, "East");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)new JLabel(AppResource.appText("drum_convert.current")), "West");
            jPanel4.add((Component)this.mabiLabel, "Center");
            JButton jButton4 = new JButton(imageIcon);
            jButton4.setFocusable(false);
            jButton4.addMouseListener(new DMouseListener(this.c.inst, () -> this.selectedCurrentMabiKey(false)));
            jPanel4.add((Component)jButton4, "East");
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.add((Component)new JLabel(AppResource.appText("drum_convert.change")), "West");
            jPanel5.add(this.combo, "Center");
            JButton jButton5 = new JButton(imageIcon);
            jButton5.setFocusable(false);
            jButton5.addMouseListener(new DMouseListener(this.c.inst, () -> this.selectedMabiKey(false)));
            jPanel5.add((Component)jButton5, "East");
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel3, "North");
            jPanel6.add((Component)jPanel4, "Center");
            jPanel6.add((Component)jPanel5, "South");
            jPanel.add((Component)jPanel2, "South");
            jPanel.add((Component)jPanel6, "Center");
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.setPreferredSize(new Dimension(600, 400));
            JPanel jPanel7 = UIUtils.createTitledPanel("drum_convert.map", new BorderLayout());
            jPanel7.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel(" * GM: General MIDI");
            jPanel7.add((Component)jLabel, "South");
            JPanel jPanel8 = new JPanel(new BorderLayout());
            JPanel jPanel9 = new JPanel();
            JPanel jPanel10 = new JPanel();
            Vector<SettingButtonGroupItem.SettingButtonItem> vector2 = new Vector<SettingButtonGroupItem.SettingButtonItem>();
            for (SettingButtonGroupItem.SettingButtonItem settingButtonItem : SettingButtonGroupItem.SettingButtonItem.create(modes)) {
                vector2.add(settingButtonItem);
            }
            Collections.reverse(vector2);
            this.modeCombo = new JComboBox(vector2);
            this.modeCombo.addActionListener(this);
            this.execButton.addActionListener(this);
            this.updateExecButtonStatus();
            this.closeButton.addActionListener(this);
            jDialog.getRootPane().setDefaultButton(this.execButton);
            jPanel9.add(this.modeCombo);
            jPanel9.add(this.execButton);
            jPanel10.add(this.closeButton);
            jPanel8.add((Component)jPanel9, "Center");
            jPanel8.add((Component)jPanel10, "South");
            this.add((Component)jPanel7, "North");
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel8, "South");
        }

        private void updateCombo(boolean bl) {
            int n = this.table.getSelectedRow();
            KeyMap keyMap = this.getKeyMap(n);
            KeyMap keyMap2 = this.c.drumMap.get(keyMap);
            this.midLabel.setText(keyMap == null ? "-" : keyMap.toString());
            this.mabiLabel.setText(keyMap2.toString());
            if (!bl) {
                this.combo.removeAllItems();
                this.c.mabiMap.entrySet().forEach(entry -> this.combo.addItem((KeyMap)entry.getValue()));
                this.combo.setSelectedItem(this.c.drumMap.get(keyMap));
                this.combo.setEnabled(true);
            }
        }

        private void setKeyMap(int n, KeyMap keyMap, KeyMap keyMap2) {
            this.c.drumMap.put(keyMap, keyMap2);
            this.table.getModel().setValueAt(keyMap2.keyName, n, 2);
            this.table.getModel().setValueAt(this.mabiName(keyMap, keyMap2), n, 3);
            this.updateCombo(true);
        }

        private int selectedMidKey() {
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return -1;
            }
            KeyMap keyMap = this.getKeyMap(n);
            return keyMap != null ? keyMap.key : -1;
        }

        private int setDefaultMabiKey() {
            int n = this.table.getSelectedRow();
            if (n >= 0) {
                KeyMap keyMap = this.getKeyMap(n);
                KeyMap keyMap2 = this.c.defaultMap.get(keyMap);
                this.setKeyMap(n, keyMap, keyMap2);
                this.c.saveData();
                return keyMap2.key;
            }
            return -1;
        }

        private int selectedCurrentMabiKey(boolean bl) {
            int n = this.table.getSelectedRow();
            if (n >= 0) {
                KeyMap keyMap = this.getKeyMap(n);
                KeyMap keyMap2 = this.c.drumMap.get(keyMap);
                if (bl) {
                    this.setKeyMap(n, keyMap, keyMap2);
                    this.c.saveData();
                }
                return keyMap2.key;
            }
            return -1;
        }

        private int selectedMabiKey(boolean bl) {
            int n = -1;
            Object object = this.combo.getSelectedItem();
            if (object instanceof KeyMap) {
                KeyMap keyMap = (KeyMap)object;
                int n2 = this.table.getSelectedRow();
                if (n2 >= 0) {
                    KeyMap keyMap2 = this.getKeyMap(n2);
                    if (bl) {
                        this.setKeyMap(n2, keyMap2, keyMap);
                        this.c.saveData();
                    }
                    n = keyMap.key;
                }
            }
            return n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.closeButton) {
                this.dialog.setVisible(false);
            } else if (object == this.execButton) {
                this.apply();
            } else if (object == this.modeCombo) {
                this.updateExecButtonStatus();
            }
        }

        private RangeMode getCurrentRangeMode() {
            SettingButtonGroupItem.SettingButtonItem settingButtonItem;
            SettingButtonGroupItem settingButtonGroupItem;
            Object object = this.modeCombo.getSelectedItem();
            if (object instanceof SettingButtonGroupItem.SettingButtonItem && (settingButtonGroupItem = (settingButtonItem = (SettingButtonGroupItem.SettingButtonItem)object).getItem()) instanceof RangeMode) {
                object = (RangeMode)settingButtonGroupItem;
                return object;
            }
            return null;
        }

        private void apply() {
            RangeMode rangeMode = this.getCurrentRangeMode();
            if (rangeMode != null) {
                this.c.midDrum2MabiDrum(this.mmlManager, rangeMode);
            }
        }

        private void updateExecButtonStatus() {
            RangeMode rangeMode = this.getCurrentRangeMode();
            if (rangeMode != null) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                rangeMode.action(this.mmlManager, (int n, int n2) -> {
                    MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(n);
                    if (DrumConverter.isDrumTrack(mMLTrack)) {
                        atomicBoolean.set(true);
                    }
                });
                this.execButton.setEnabled(atomicBoolean.get());
            }
        }

        @Override
        public void notifyUpdateEditState() {
            this.updateExecButtonStatus();
        }

        private static final class DMouseListener
        extends MouseAdapter {
            private final InstClass inst;
            private final Supplier<Integer> f;

            private DMouseListener(InstClass instClass, Supplier<Integer> supplier) {
                this.inst = instClass;
                this.f = supplier;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.playNote(this.f.get());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.playNote(-1);
            }

            private void playNote(int n) {
                boolean bl = this.inst == null;
                int n2 = 0;
                MabiDLS mabiDLS = MabiDLS.getInstance();
                if (!bl) {
                    mabiDLS.loadRequiredInstruments(List.of(this.inst));
                    n2 = this.inst.getProgram();
                }
                mabiDLS.playDrum(bl, n, 100, n2);
            }
        }
    }
}

