/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.fourthline.mabiicco.IFileState;
import jp.fourthline.mabiicco.IFileStateObserver;
import jp.fourthline.mabiicco.Utils;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mmlTools.MMLScore;

public final class MMLScoreUndoEdit
extends AbstractUndoableEdit
implements IFileState {
    private static final long serialVersionUID = 4093930608712571204L;
    private IFileStateObserver fileStateObserver = null;
    private static final int MAX_UNDO = 20;
    private final Stack<byte[]> undoState = new Stack();
    private final Stack<byte[]> redoState = new Stack();
    private final IMMLManager mmlManager;
    private int originalIndex = 0;

    public MMLScoreUndoEdit(IMMLManager iMMLManager) {
        this.mmlManager = iMMLManager;
    }

    public void initState() {
        this.undoState.clear();
        this.redoState.clear();
        this.originalIndex = 0;
        this.saveState();
    }

    @Override
    public void saveState() {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        byte[] byArray = mMLScore.getObjectState();
        if (!this.undoState.empty() && Arrays.equals(byArray, (byte[])this.undoState.lastElement())) {
            return;
        }
        this.undoState.push(byArray);
        this.redoState.clear();
        if (this.undoState.size() > 20) {
            this.undoState.remove(0);
            this.originalIndex = -1;
        }
        if (this.fileStateObserver != null) {
            this.fileStateObserver.notifyUpdateFileState();
        }
        System.out.println("saveState() " + this.undoState.size());
    }

    @Override
    public void revertState() {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        mMLScore.putObjectState((byte[])this.undoState.lastElement());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        if (this.canUndo()) {
            byte[] byArray = this.undoState.pop();
            mMLScore.putObjectState((byte[])this.undoState.lastElement());
            this.redoState.push(byArray);
            this.makeBackup();
            if (this.fileStateObserver != null) {
                this.fileStateObserver.notifyUpdateFileState();
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        if (this.canRedo()) {
            byte[] byArray = this.redoState.pop();
            mMLScore.putObjectState(byArray);
            this.undoState.push(byArray);
            this.makeBackup();
            if (this.fileStateObserver != null) {
                this.fileStateObserver.notifyUpdateFileState();
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoState.size() > 1;
    }

    @Override
    public boolean canRedo() {
        return !this.redoState.empty();
    }

    @Override
    public boolean isModified() {
        return this.originalIndex != this.undoState.size() - 1;
    }

    @Override
    public void setOriginalBase() {
        this.originalIndex = this.undoState.size() - 1;
    }

    @Override
    public void setFileStateObserver(IFileStateObserver iFileStateObserver) {
        this.fileStateObserver = iFileStateObserver;
    }

    private String makeBackup() {
        String string = null;
        try {
            string = Utils.compress(this.makeBackupString());
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    private void writeStack(PrintStream printStream, Stack<byte[]> stack) throws IOException {
        printStream.println(stack.size());
        for (byte[] byArray : stack) {
            printStream.println(Base64.getEncoder().encodeToString(byArray));
        }
    }

    private void readStack(BufferedReader bufferedReader, Stack<byte[]> stack) throws IOException {
        stack.clear();
        int n = Integer.parseInt(bufferedReader.readLine());
        for (int i = 0; i < n; ++i) {
            stack.add(Base64.getDecoder().decode(bufferedReader.readLine()));
        }
    }

    private String makeBackupString() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, StandardCharsets.UTF_8);
        printStream.println(4093930608712571204L);
        this.writeStack(printStream, this.undoState);
        this.writeStack(printStream, this.redoState);
        printStream.println(this.originalIndex);
        printStream.close();
        return byteArrayOutputStream.toString();
    }

    private boolean parseBackupString(String string) throws IOException, NumberFormatException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        long l = Long.parseLong(bufferedReader.readLine());
        if (l != 4093930608712571204L) {
            return false;
        }
        this.readStack(bufferedReader, this.undoState);
        this.readStack(bufferedReader, this.redoState);
        this.originalIndex = Integer.parseInt(bufferedReader.readLine());
        return true;
    }

    public boolean recover(String string) {
        try {
            byte[] byArray = Utils.decompress(string);
            if (byArray == null) {
                return false;
            }
            boolean bl = this.parseBackupString(new String(byArray));
            this.makeBackup();
            return bl;
        }
        catch (IOException | NumberFormatException exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    public String getBackupString() {
        return this.makeBackup();
    }
}

