/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;
import jp.fourthline.mmlTools.parser.MMLFile;

public final class MMLTextEditor
implements DocumentListener,
CaretListener {
    private final JDialog dialog;
    private final Window parentFrame;
    private final JPanel panel;
    private final JScrollPane scrollPane;
    private final JTextPane textPane = new JTextPane();
    private final DefaultStyledDocument doc = new DefaultStyledDocument(new StyleContext());
    private static final ColorSet emptyStyleColor = ColorSet.create(Color.DARK_GRAY, Color.GRAY);
    private static final ColorSet normalStyleColor = ColorSet.create(Color.BLACK, Color.LIGHT_GRAY);
    private static final ColorSet tokenStyleColor = ColorSet.create(Color.BLUE, Color.CYAN);
    private static final ColorSet commentStyleColor = ColorSet.create(Color.decode("#006400"), Color.decode("#66AA66"));
    private final AttributeSet emptyStyle = MMLTextEditor.createAttribute(emptyStyleColor.get());
    private final AttributeSet normalStyle = MMLTextEditor.createAttribute(normalStyleColor.get());
    private final AttributeSet tokenStyle = MMLTextEditor.createAttribute(tokenStyleColor.get());
    private final AttributeSet commentStyle = MMLTextEditor.createAttribute(commentStyleColor.get());
    private final List<Pattern> commentPatterns = List.of(Pattern.compile("/\\*/?([^/]|[^*]/)*\\*/"), Pattern.compile("//.*\n"));
    private final MMLEventList originalList;
    private final List<MMLTempoEvent> originalTempoList;
    private final IMMLManager mmlManager;
    private final JButton okButton = new JButton(AppResource.appText("mml.input.okButton"));
    private final JButton cancelButton = new JButton(AppResource.appText("mml.input.cancelButton"));
    private final long initialPosition;
    private final PianoRollView pianoRollView;

    private static AttributeSet createAttribute(Color color) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        return simpleAttributeSet;
    }

    public MMLTextEditor(Frame frame, IMMLManager iMMLManager, PianoRollView pianoRollView) throws MMLExceptionList {
        this.textPane.setDocument(this.doc);
        this.textPane.addCaretListener(this);
        this.textPane.setFont(AppResource.MONO_FONT);
        this.textPane.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                ancestorEvent.getComponent().requestFocusInWindow();
            }
        });
        this.doc.setParagraphAttributes(0, 0, this.emptyStyle, false);
        this.mmlManager = iMMLManager;
        this.originalList = iMMLManager.getActiveMMLPart();
        this.originalTempoList = new ArrayList<MMLTempoEvent>(this.originalList.getGlobalTempoList());
        int n = iMMLManager.getActiveMMLPartIndex();
        int n2 = iMMLManager.getActiveTrack().getStartOffset(n);
        MMLBuilder mMLBuilder = MMLBuilder.create(iMMLManager.getActiveMMLPart(), n2);
        String string = new MMLStringOptimizer(mMLBuilder.toMMLString(true, false)).optimizeForTextEditor();
        this.textPane.setText(string);
        this.applyStyle();
        this.parentFrame = frame;
        this.dialog = new JDialog(frame, AppResource.appText("mml.text_edit"), true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                MMLTextEditor.this.cancelAction();
            }
        });
        UIUtils.dialogCloseAction(this.dialog, this::cancelAction);
        this.scrollPane = new JScrollPane(this.textPane, 22, 30);
        this.scrollPane.setPreferredSize(new Dimension(400, 240));
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.scrollPane, "Center");
        this.okButton.addActionListener(actionEvent -> this.applyAction());
        this.okButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        this.cancelButton.addActionListener(actionEvent -> this.cancelAction());
        this.cancelButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.panel.add((Component)jPanel, "South");
        this.doc.addDocumentListener(this);
        this.pianoRollView = pianoRollView;
        this.initialPosition = pianoRollView != null ? pianoRollView.getSequencePosition() : 0L;
    }

    private void applyStyle() {
        try {
            String string = this.doc.getText(0, this.doc.getLength());
            this.doc.setCharacterAttributes(0, string.length(), this.emptyStyle, true);
            MMLTokenizer mMLTokenizer = new MMLTokenizer(string);
            while (mMLTokenizer.hasNext()) {
                String string2 = mMLTokenizer.next();
                int[] nArray = mMLTokenizer.getIndex();
                AttributeSet attributeSet = MMLTokenizer.isNote(string2.charAt(0)) ? this.normalStyle : this.tokenStyle;
                this.doc.setCharacterAttributes(nArray[0], 1, attributeSet, true);
            }
            this.commentPatterns.forEach(pattern -> {
                Matcher matcher = pattern.matcher(string + "\n");
                int n = 0;
                while (matcher.find(n)) {
                    int n2 = matcher.start();
                    int n3 = matcher.end();
                    this.doc.setCharacterAttributes(n2, n3 - n2, this.commentStyle, true);
                    n = matcher.end();
                }
            });
            this.setMML(string);
            if (this.parentFrame != null) {
                this.parentFrame.repaint();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setMML(String string) {
        string = MMLFile.toMMLText(string);
        boolean bl = true;
        int n = this.mmlManager.getActiveMMLPartIndex();
        int n2 = this.mmlManager.getActiveTrack().getStartOffset(n);
        MMLEventList mMLEventList = new MMLEventList(string, null, n2);
        try {
            mMLEventList.getInternalMMLString();
        }
        catch (MMLExceptionList mMLExceptionList) {
            bl = false;
        }
        this.mmlManager.getActiveTrack().getMMLEventList().set(n, mMLEventList);
        List<MMLTempoEvent> list = this.mmlManager.getMMLScore().getTempoEventList();
        list.clear();
        MMLTempoEvent.mergeTempoList(this.originalTempoList, list);
        MMLTempoEvent.mergeTempoList(mMLEventList.getGlobalTempoList(), list);
        this.okButton.setEnabled(bl);
    }

    public void cancelAction() {
        int n = this.mmlManager.getActiveMMLPartIndex();
        this.mmlManager.getActiveTrack().getMMLEventList().set(n, this.originalList);
        List<MMLTempoEvent> list = this.mmlManager.getMMLScore().getTempoEventList();
        list.clear();
        list.addAll(this.originalTempoList);
        if (this.parentFrame != null) {
            this.parentFrame.repaint();
        }
        if (this.pianoRollView != null) {
            this.pianoRollView.setSequenceTick(this.initialPosition);
        }
    }

    public void applyAction() {
        int n = this.mmlManager.getActiveMMLPartIndex();
        this.mmlManager.getActiveTrack().getMMLEventList().get(n).setGlobalTempoList(this.originalList.getGlobalTempoList());
        this.mmlManager.updateActivePart(true);
        if (this.pianoRollView != null) {
            this.pianoRollView.setSequenceTick(this.initialPosition);
        }
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this.panel);
        this.dialog.pack();
        this.dialog.setMinimumSize(new Dimension(200, 200));
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(() -> this.applyStyle());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(() -> this.applyStyle());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        try {
            String string = this.doc.getText(0, this.doc.getLength());
            long l = this.tickMMLPosition(string, caretEvent.getDot());
            if (this.pianoRollView != null) {
                this.pianoRollView.setSequenceTick(l);
                this.mmlManager.updatePianoRollView();
            }
            if (this.parentFrame != null) {
                this.parentFrame.repaint();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    long tickMMLPosition(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        MMLTokenizer mMLTokenizer = new MMLTokenizer(MMLFile.toMMLText(string).toLowerCase().replaceAll("r", "c"));
        while (mMLTokenizer.hasNext()) {
            String string2 = mMLTokenizer.next();
            int n2 = mMLTokenizer.getEnd();
            if (n2 > n) break;
            stringBuilder.append(string2);
        }
        return new MMLEventList(stringBuilder.toString()).getTickLength();
    }
}

