/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import jp.fourthline.mmlTools.core.ResourceLoader;

public final class ComposeRank {
    private static final String RESOURCE_NAME = "rank";
    private static final ComposeRank RANK_0 = new ComposeRank(0, 0, 0, "-");
    private static final ArrayList<ComposeRank> rankList = new ArrayList();
    private static final ArrayList<ComposeRank> excludeSongRankList = new ArrayList();
    private int melody;
    private int chord1;
    private int chord2;
    private String rank = "-";

    private static void loadRankResource(List<ComposeRank> list, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, new ResourceLoader());
        for (String string2 : Collections.list(resourceBundle.getKeys())) {
            String[] stringArray = resourceBundle.getString(string2).split(",");
            if (stringArray.length != 4) continue;
            int n = Integer.parseInt(stringArray[0].trim());
            int n2 = Integer.parseInt(stringArray[1].trim());
            int n3 = Integer.parseInt(stringArray[2].trim());
            list.add(new ComposeRank(n, n2, n3, stringArray[3].trim()));
        }
        list.sort(Comparator.comparingInt(composeRank -> composeRank.melody + composeRank.chord1 + composeRank.chord2));
    }

    public static ComposeRank getTopRank() {
        return rankList.get(rankList.size() - 1);
    }

    public static ComposeRank getTopExcludeSongRank() {
        return excludeSongRankList.get(excludeSongRankList.size() - 1);
    }

    public static ComposeRank mmlRank(String string, String string2, String string3, String string4) {
        return ComposeRank.mmlRank(string.length(), string2.length(), string3.length(), string4.length());
    }

    public static ComposeRank mmlRank(int n, int n2, int n3, int n4) {
        return ComposeRank.mmlRank(rankList, n, n2, n3, n4);
    }

    public static ComposeRank mmlExcludeSongRank(String string, String string2, String string3, String string4) {
        return ComposeRank.mmlExcludeSongRank(string.length(), string2.length(), string3.length(), string4.length());
    }

    public static ComposeRank mmlExcludeSongRank(int n, int n2, int n3, int n4) {
        return ComposeRank.mmlRank(excludeSongRankList, n, n2, n3, n4);
    }

    private static ComposeRank mmlRank(List<ComposeRank> list, int n, int n2, int n3, int n4) {
        for (ComposeRank composeRank : list) {
            if (!composeRank.compare(n, n2, n3, n4)) continue;
            return composeRank;
        }
        return RANK_0;
    }

    private ComposeRank() {
    }

    private ComposeRank(int n, int n2, int n3) {
        this.melody = n;
        this.chord1 = n2;
        this.chord2 = n3;
    }

    private ComposeRank(int n, int n2, int n3, String string) {
        this(n, n2, n3);
        this.rank = string;
    }

    public boolean compare(int n, int n2, int n3, int n4) {
        return n <= this.melody && n2 <= this.chord1 && n3 <= this.chord2 && n4 <= this.melody;
    }

    public int getMelody() {
        return this.melody;
    }

    public int getChord1() {
        return this.chord1;
    }

    public int getChord2() {
        return this.chord2;
    }

    public String getRank() {
        return this.rank;
    }

    public boolean canCompose() {
        return this != RANK_0;
    }

    public String toString() {
        return "Rank " + this.rank + " ( " + this.melody + ", " + this.chord1 + ", " + this.chord2 + " )";
    }

    static {
        ComposeRank.loadRankResource(rankList, RESOURCE_NAME);
        rankList.forEach(composeRank -> {
            int n = composeRank.getMelody() / 3;
            ComposeRank composeRank2 = new ComposeRank(composeRank.getMelody() + n, composeRank.getChord1() + n, composeRank.getChord2() + n, composeRank.getRank() + "`");
            excludeSongRankList.add(composeRank2);
        });
    }
}

