/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.Map;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTools;
import jp.fourthline.mmlTools.core.MelodyParser;

public class MMLTimeTools
extends MMLTools {
    public static final int CHECK_RANGE_N = 5;
    private final int[] minTable = new int[]{16, 48, 60, 24, 12};
    private final int[] maxTable = new int[]{88, 83, 88, 59, 59};

    public MMLTimeTools(String string, boolean bl) throws MMLException {
        super(string);
        this.parseMMLforMabinogi();
        this.parsePlayMode(bl);
    }

    public boolean[] checkRange() {
        int n;
        MelodyParser[] melodyParserArray = new MelodyParser[]{this.melodyParser, this.chord1Parser, this.chord2Parser};
        boolean[] blArray = new boolean[this.minTable.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = true;
        }
        block1: for (n = 0; n < this.minTable.length; ++n) {
            for (int i = 0; i < melodyParserArray.length; ++i) {
                int n2 = melodyParserArray[i].getMinNote();
                int n3 = melodyParserArray[i].getMaxNote();
                if (n2 < 0 || n3 < 0 || this.minTable[n] <= n2 && this.maxTable[n] >= n3) continue;
                blArray[n] = false;
                continue block1;
            }
        }
        return blArray;
    }

    public Map<Integer, Integer> getPlayList() throws MMLException {
        return this.playParser.getTempoList();
    }

    public Map<Integer, Integer> getMelodyList() throws MMLException {
        return this.melodyParser.getTempoList();
    }

    public Map<Integer, Integer> getChord1List() throws MMLException {
        return this.chord1Parser.getTempoList();
    }

    public Map<Integer, Integer> getChord2List() throws MMLException {
        return this.chord2Parser.getTempoList();
    }
}

