/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.List;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public final class Measure {
    private final int measure;
    private final int beat;
    private final int tick;
    private final int numTime;
    private final int beatTick;
    private final int measuredTick;

    public static int measuredTick(MMLScore mMLScore, int n) {
        return new Measure(mMLScore, n).measuredTick();
    }

    public static int tickToMeasure(MMLScore mMLScore, int n) {
        return new Measure(mMLScore, n).getMeasure();
    }

    public static int nextMeasure(MMLScore mMLScore, int n, boolean bl) {
        Measure measure = new Measure(mMLScore, n);
        n = bl ? (n += measure.getMeasureTick()) : (n -= measure.getBeatTick());
        n = new Measure(mMLScore, n).measuredTick();
        return n;
    }

    public Measure(MMLScore mMLScore, int n) {
        List<TimeSignature> list = mMLScore.getTimeSignatureList();
        int n2 = mMLScore.getTimeCountOnly();
        int n3 = mMLScore.getBeatTick();
        int n4 = 0;
        int n5 = 0;
        for (TimeSignature timeSignature : list) {
            if (timeSignature.getTickOffset() > n) break;
            n5 = timeSignature.getTickOffset();
            n4 = timeSignature.getMeasureOffset();
            n3 = timeSignature.getBaseTick();
            n2 = timeSignature.getNumTime();
        }
        this.measure = n4 + (n - n5) / (n3 * n2);
        int n6 = (n - n5) % (n3 * n2);
        this.beat = n6 / n3;
        this.tick = n6 % n3;
        this.numTime = n2;
        this.beatTick = n3;
        this.measuredTick = n - this.beat * this.beatTick - this.tick;
    }

    public int getMeasure() {
        return this.measure;
    }

    public int getBeat() {
        return this.beat;
    }

    public int getBeatTick() {
        return this.beatTick;
    }

    public int getNumTime() {
        return this.numTime;
    }

    public int getMeasureTick() {
        return this.numTime * this.beatTick;
    }

    public int measuredTick() {
        return this.measuredTick;
    }

    public String timeCount() {
        return Integer.toString(this.numTime);
    }

    public String timeBase() throws MMLException {
        return new MMLTicks("", this.beatTick).toMMLText();
    }

    public String toString() {
        if (this.beatTick >= 100) {
            return String.format("%d:%02d:%03d", this.measure, this.beat, this.tick);
        }
        return String.format("%d:%02d:%02d", this.measure, this.beat, this.tick);
    }
}

