/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MMLTokenizer
implements Iterator<String> {
    private static final String noteString = "abcdefgABCDEFGnNrR";
    private static final String tokenString = "abcdefgABCDEFGnNrRtToOlLvV<>&,";
    private final String mml_src;
    private final int mml_length;
    private final char[] mml_charArray;
    private int startIndex = 0;
    private int endIndex = 0;
    private static final Map<String, String[]> tokenCache = Collections.synchronizedMap(new HashMap());

    public MMLTokenizer(String string) {
        this.mml_src = string;
        this.mml_length = string.length();
        this.mml_charArray = string.toCharArray();
    }

    @Override
    public boolean hasNext() {
        return this.endIndex < this.mml_length;
    }

    @Override
    public String next() {
        this.startIndex = this.endIndex;
        this.endIndex = this.searchToken(this.endIndex + 1);
        return this.mml_src.substring(this.startIndex, this.endIndex);
    }

    @Override
    public void remove() {
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public int getStart() {
        return this.startIndex;
    }

    public int getEnd() {
        return this.endIndex;
    }

    public int[] getIndex() {
        return new int[]{this.startIndex, this.endIndex};
    }

    public static boolean isToken(char c) {
        return tokenString.indexOf(c) >= 0;
    }

    public static boolean isNote(char c) {
        return noteString.indexOf(c) >= 0;
    }

    public static String noteName(String string) {
        char c;
        Object object = string.substring(0, 1);
        if (string.length() > 1 && ((c = string.charAt(1)) == '+' || c == '-' || c == '#')) {
            object = (String)object + c;
        }
        return object;
    }

    public static String[] noteNames(String string) {
        String[] stringArray = tokenCache.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        String string2 = MMLTokenizer.noteName(string);
        String string3 = string.substring(string2.length());
        String[] stringArray2 = new String[]{string2, string3};
        tokenCache.put(string, stringArray2);
        return stringArray2;
    }

    public static boolean isLenOnly(String string) {
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.matches("[0-9]+");
    }

    public int searchToken(int n) {
        char c;
        int n2;
        for (n2 = n; n2 < this.mml_length && !MMLTokenizer.isToken(c = this.mml_charArray[n2]); ++n2) {
        }
        return n2;
    }

    public int backSearchToken(int n) {
        char c;
        int n2;
        for (n2 = n - 1; n2 >= 0 && !MMLTokenizer.isToken(c = this.mml_charArray[n2]); --n2) {
        }
        return n2;
    }
}

