/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.List;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MelodyParser;

public class MMLTools {
    protected String mml_melody = "";
    protected String mml_chord1 = "";
    protected String mml_chord2 = "";
    protected String mml_songEx = "";
    protected MelodyParser playParser;
    protected MelodyParser melodyParser;
    protected MelodyParser chord1Parser;
    protected MelodyParser chord2Parser;
    protected MelodyParser songExParser;
    private double play_length = -1.0;
    private double mabinogi_length = -1.0;

    protected void clearTimeCalc() {
        this.play_length = -1.0;
        this.mabinogi_length = -1.0;
    }

    public double getPlayTime() throws MMLException {
        if (this.play_length < 0.0) {
            this.play_length = this.playParser.getPlayLengthByTempoList();
        }
        return this.play_length;
    }

    public double getMabinogiTime() throws MMLException {
        if (this.mabinogi_length < 0.0) {
            double d = 0.0;
            double[] dArray = new double[]{this.melodyParser.getPlayLengthByTempoList(), this.chord1Parser.getPlayLengthByTempoList(), this.chord2Parser.getPlayLengthByTempoList()};
            for (int i = 0; i < dArray.length; ++i) {
                d = Math.max(d, dArray[i]);
            }
            this.mabinogi_length = d;
        }
        return this.mabinogi_length;
    }

    public void parseMMLforMabinogi() throws MMLException {
        this.melodyParser = new MelodyParser(this.mml_melody);
        this.chord1Parser = new MelodyParser(this.mml_chord1, "4", this.melodyParser.getTempo());
        this.chord2Parser = new MelodyParser(this.mml_chord2, "4", this.chord1Parser.getTempo());
    }

    public void parsePlayMode(boolean bl) throws MMLException {
        if (bl) {
            String string = this.mml_melody + "T" + this.melodyParser.getTempo() + this.mml_chord1 + "T" + this.chord1Parser.getTempo() + this.mml_chord2;
            this.playParser = new MelodyParser(string);
        } else {
            this.playParser = new MelodyParser(this.mml_melody);
            int n = this.playParser.getTempoList().get(0);
            this.playParser.mergeParser(new MelodyParser(this.mml_chord1, "4", n));
            this.playParser.mergeParser(new MelodyParser(this.mml_chord2, "4", n));
        }
    }

    public MMLTools() {
    }

    public MMLTools(String string) {
        String[] stringArray;
        if (!string.startsWith("MML@")) {
            string = "";
            return;
        }
        int n = 4;
        int n2 = string.indexOf(";");
        if (n2 <= 0) {
            n2 = string.length();
        }
        if ((stringArray = (string = string.substring(n, n2)).split(",")).length > 0) {
            this.mml_melody = stringArray[0];
        }
        if (stringArray.length > 1) {
            this.mml_chord1 = stringArray[1];
        }
        if (stringArray.length > 2) {
            this.mml_chord2 = stringArray[2];
        }
        if (stringArray.length > 3) {
            this.mml_songEx = stringArray[3];
        }
    }

    public MMLTools(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public MMLTools(String string, String string2, String string3, String string4) {
        this.mml_melody = string;
        this.mml_chord1 = string2;
        this.mml_chord2 = string3;
        this.mml_songEx = string4;
    }

    public String getMelody() {
        return this.mml_melody;
    }

    public String getChord1() {
        return this.mml_chord1;
    }

    public String getChord2() {
        return this.mml_chord2;
    }

    public String getSongEx() {
        return this.mml_songEx;
    }

    protected boolean hasSongPart() {
        return this.mml_songEx != null && this.mml_songEx.length() > 0;
    }

    public String getMML() {
        String string = "MML@" + this.mml_melody + "," + this.mml_chord1 + "," + this.mml_chord2;
        if (this.hasSongPart()) {
            string = string + "," + this.mml_songEx;
        }
        string = string + ";";
        return string;
    }

    private String toStringFormatWarnList(List<Integer> list) {
        Object object = "";
        for (int i = 0; i < list.size(); ++i) {
            object = (String)object + list.get(i) + ", ";
        }
        return object;
    }

    public String getMMLWarning() {
        Object object = this.toStringFormatWarnList(this.melodyParser.getWarnIndex());
        object = (String)object + this.toStringFormatWarnList(this.chord1Parser.getWarnIndex());
        object = (String)object + this.toStringFormatWarnList(this.chord2Parser.getWarnIndex());
        return object;
    }

    public boolean checkPitch(int n, int n2) throws MMLException {
        this.parseMMLforMabinogi();
        this.parsePlayMode(false);
        return this.melodyParser.checkPitch(n, n2) && this.chord1Parser.checkPitch(n, n2) && this.chord2Parser.checkPitch(n, n2);
    }
}

